// Simple code to produce event tables
{
  FrFile * iFile = FrFileINew("V-WSR8-Injections-12-Feb-2007-855272816-10000.gwf V-WSR8-Injections-07-Feb-2007-855105001-10000.gwf");

  FrSimEvent * simEvent;
  FrSimEvent * ptrEvent;

  char tableFileName[256];

  // Some details about the generation
  long gpsStart = 855105000;
  long duration = 399800;

  // Some declarations for the parameters of the event
  double gps, tBefore, tAfter;
  double hrss, SNR;
  double DEC, AR, Psi;
  double Fp, Fc, Ap, Ac;

  // get the names of the events
  FrVect * eventTypes;
  int nEventTypes;
  eventTypes = FrFileIGetSimEventNames(iFile);
  
  // for each type build a table
  for(int iType=0; iType < eventTypes->nData; iType++) {
    sprintf(tableFileName,"tables/%s.tab",eventTypes->dataQ[iType]);
    FILE * tableFile = fopen(tableFileName,"w");
    simEvent = FrSimEventReadTF(iFile,
				eventTypes->dataQ[iType],
				gpsStart,
				duration,
				0, 0);
    ptrEvent = simEvent;
    fprintf(stderr,"Starting %s ...",tableFileName);
    fprintf(tableFile,"# GPS\ttBefore\ttAfter\thrss\tSNR\n");
    while(ptrEvent != NULL) {
      fprintf(tableFile,
	      "%.16g\t%g\t%g\t%g\t%g\n",
	      ((double) ptrEvent->GTimeS + 
	       1.0e-9 * ((double) ptrEvent->GTimeN)),
	      ptrEvent->timeBefore,
	      ptrEvent->timeAfter,
	      FrSimEventGetParam(ptrEvent,"hrss"),
	      FrSimEventGetParam(ptrEvent,"SNR"));
      ptrEvent = ptrEvent->next;
    }
    fclose(tableFile);
    fprintf(stderr,"\n");
    FrSimEventFree(simEvent);
  }
}
