#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "FrameL.h"

/*--------------auxiliary function: to add parameters to a SimEvent ----*/
int parseFileName(FrSimEvent *event,
		  char *eq, char *sep, char *input, double snrScale)
/*----------------------------------------------------------------------*/
{
  int useScale = 0;
  int ris = 0;
  char ** ptr = NULL;
  char * string = NULL;
  char *n, *v, *c;

  /* errors */
  if(event == NULL)
    return -1;
  else if(input == NULL)
    return -2;
  string = strdup(input);

  /* eliminate the extension, it should be ".txt" */
  n = strstr(string,".txt");
  if(n != NULL) *n = '\0';

  /* break the input name into pairs */
  ptr = (char**) malloc(sizeof(char*));
  n = strtok_r(string, eq, ptr);
  v = strtok_r(NULL,  sep, ptr);
  /* eliminate the head, if present */
  if((c = strstr(n, sep)) != NULL)
    n = c+1;
  /* another time to jump over VSR1_hi */
  if((c = strstr(n, sep)) != NULL)
    n = c+1;
  while(n != NULL && v != NULL) {
    if(strncmp(n,"time",4)==0) {
      FrSimEventAddParam(event, n,
                         atof(v) -
                         (double) event->GTimeS -
                         1.0e-9 * ((double) event->GTimeN));
      ris++;
    } else if(strncmp(n,"TRUESNR",7) == 0 ||
	      strncmp(n,"hrssOriginal",12) == 0 ||
	      strncmp(n,"SNROriginal",11) == 0 ||
	      strncmp(n,"sampling",8) == 0 ||
	      (strncmp(n,"hrss",4) == 0 && atof(v) == 1.0)) {
    } else if(strncmp(n,"distance",8) == 0) {
      useScale = 1;
    } else if(strncmp(n,"scale",5) == 0) {
      if(useScale) {
	useScale = 0;
	FrSimEventAddParam(event, "distance", 1./atof(v));
	ris++;
      }
    } else if(strncmp(n,"SNR",3)==0) {
      FrSimEventAddParam(event, "NOMINAL_SNR",
                         atof(v)*snrScale);
      ris++;
    } else if(strncmp(n,"hrss",4)==0) {
      FrSimEventAddParam(event, "hrss",
                         atof(v)*snrScale);
      ris++;
    } else {
      FrSimEventAddParam(event, n, atof(v));
      ris++;
    }
    n = strtok_r(NULL, eq, ptr);
    v = strtok_r(NULL, sep, ptr);
  }
  /* free the memory */
  free(string);
  free(ptr);
  /* returns the number of parameters added */
  return ris;
}
