// Simple code to produce event tables
{
  FrFile * iFile = FrFileINew("V-VSR1_LoudInjections.ffl");

  if(iFile == NULL) {
    fprintf(stderr,"Unable to load FFL V-VSR1_LoudINjections.ffl\n");
    exit(1);
  }

  FrSimEvent * simEvent;
  FrSimEvent * ptrEvent;

  char tableFileName[256];

  // Some details about the generation
  long gpsStart = 863532000;
  long duration = 12554976;

  // Some declarations for the parameters of the event
  double gps, tBefore, tAfter;
  double hrss, SNR;

  // get the names of the events
  FrVect * eventTypes;
  int nEventTypes;
  eventTypes = FrFileIGetSimEventNames(iFile);
  
  // for each type build a table
  for(int iType=0; iType < eventTypes->nData; iType++) {
    sprintf(tableFileName,"tables/%s%s.tab",eventTypes->dataQ[iType],"Loud");
    FILE * tableFile = fopen(tableFileName,"w");
    simEvent = FrSimEventReadTF(iFile,
				eventTypes->dataQ[iType],
				gpsStart,
				duration,
				0, 0);
    ptrEvent = simEvent;
    fprintf(stderr,"Starting %s ...",tableFileName);
    if(strcmp(eventTypes->dataQ[iType],"HI_Burst") == 0) {
      fprintf(tableFile,"# GPS\ttBefore\ttAfter\thrss\tNOMINAL_SNR\tQ\tf0\n");
      while(ptrEvent != NULL) {
	fprintf(tableFile,
		"%.16g\t%g\t%g\t%g\t%g\t%g\t%g\n",
		((double) ptrEvent->GTimeS + 
		 1.0e-9 * ((double) ptrEvent->GTimeN)),
		ptrEvent->timeBefore,
		ptrEvent->timeAfter,
		FrSimEventGetParam(ptrEvent,"hrss"),
		FrSimEventGetParam(ptrEvent,"NOMINAL_SNR"),
		FrSimEventGetParam(ptrEvent,"Q"),
		FrSimEventGetParam(ptrEvent,"f0"));
	ptrEvent = ptrEvent->next;
      }
    } else {
      fprintf(tableFile,"# GPS\ttBefore\ttAfter\thrss\tNOMINAL_SNR\tm1\tm2\tdistance\n");
      while(ptrEvent != NULL) {
	fprintf(tableFile,
		"%.16g\t%g\t%g\t%g\t%g\t%g\t%g\t%g\n",
		((double) ptrEvent->GTimeS + 
		 1.0e-9 * ((double) ptrEvent->GTimeN)),
		ptrEvent->timeBefore,
		ptrEvent->timeAfter,
		FrSimEventGetParam(ptrEvent,"hrss"),
		FrSimEventGetParam(ptrEvent,"NOMINAL_SNR"),
		FrSimEventGetParam(ptrEvent,"m1"),
		FrSimEventGetParam(ptrEvent,"m2"),
		FrSimEventGetParam(ptrEvent,"distance"));
	ptrEvent = ptrEvent->next;
      }
    }
    fclose(tableFile);
    fprintf(stderr,"\n");
    FrSimEventFree(simEvent);
  }
}
