// Simple code which parses Hrec, extracts the FrSimEvent and
// also recomputes their approximate SNR
{
  gSystem->Load("./parseFileName_C.so");

  char buffer[1024];

  // to be changed
  FrFile * iFile = FrFileINew("VSR1-HrecOnline.ffl");

  // read list of GPS end times
  long GPSstart[512];
  long GPSend[512];
  int GPScount = 0;
  int ris;
  FILE * input = NULL;
  input = fopen("gpsEndTimes.txt","r");
  if(input == NULL) {
    fprintf(stderr,"Error: file %s not found.\n","gpsEndTimes.txt");
    exit(1);
  }
  while ( 1 ) {
    ris = fscanf(input, "%ld",GPSend + GPScount);
    if(ris == 1) {
      GPScount++;
    } else {
      fprintf(stderr,"Read %ld GPS times\n",GPScount);
      break;
    }
  }

  // Turn into GPS putative start time, with a margin
  long duration = 600;
  for(int block = 0; block < GPScount; block++) {
    GPSstart[block] = GPSend[block] - duration;
  }

  // Cycle over block of events
  FrSimEvent * simEvent;
  FrSimEvent * copyEvent;
  FILE * lisFile;
  FILE * risFile;
  risFile = fopen("VSR1_hardwareInjectionList.txt","w");
  char lisFileName[64];
  char ** lisEventString = NULL;
  lisEventString = (char**) malloc(sizeof(char*)*512);
  for(int i = 0; i < 512; i++) {
    lisEventString[i] = (char*) malloc(sizeof(char)*1024);
    if(lisEventString[i] == NULL) {
      fprintf(stderr,"failed to allocate 1024 char\n");
    }
  }

  int lisEventCount;
  for(int block = 0; block < GPScount; block++) {
    sprintf(buffer,"V-VSR1_Injections");
    FrFile * oFile = FrFileONewM(buffer,6,"hrec",duration);
    FrameH * frameH = FrameHNew("InjectionsFrame");
    frameH->dt = duration;
    frameH->GTimeS = GPSstart[block];
    frameH->GTimeN = 0;
    // for each GPS time, read the events available in Frames
    simEvent = FrSimEventReadTF(iFile,
                                "HI*",
                                GPSstart[block],
                                duration,
                                0, 0);
    // read the corresponding file 
    sprintf(lisFileName,"NIEvents_%ld.lis.awked",GPSend[block]);
    fprintf(stderr,"reading %s\n", lisFileName);
    lisFile = fopen(lisFileName,"r");
    if(lisFile == NULL) {
      fprintf(stderr,"Error: file %s not available\n",lisFileName);
      exit(1);
    } else {
      // load the file content, one string per line
      lisEventCount = 0;
      while( 1 ) {
        ris = fscanf(lisFile,"%s",lisEventString[lisEventCount]);
	//ris = fscanf(lisFile,"%s",&buffer);
        if(ris == 0 || ris == EOF) {
	  fprintf(stderr,"read %d events from file %s\n", 
		  lisEventCount, lisFileName);
          break;
        } else {
          lisEventCount++;
        }
      }
    }

    // Cycle on the events and match if possible
    int countEvent = 0;
    while(simEvent != NULL) {
      double gtime = ((double) simEvent->GTimeS + 
		      1.0e-9 * ((double) simEvent->GTimeN));
      /* print about the event found */
      FrSimEventDump(simEvent, stderr, 2);
      if(strcmp(simEvent->name,"HI_CB") == 0 || 
         strcmp(simEvent->name,"HI_Burst") == 0) {
	/* trick to set the scale for bursts */
	snrScale = 1.0;
	if(strcmp(simEvent->name, "HI_Burst") == 0 &&
	   countEvent < 13) {
	  snrScale = 0.5;
	}
        if(countEvent < lisEventCount) {
          fprintf(risFile,
                  "%.16g\t%g\t%g\t%s\n",
                  gtime, simEvent->timeBefore, simEvent->timeAfter, 
                  lisEventString[countEvent]);
	  copyEvent = FrSimEventNew(frameH,
				    simEvent->name,
				    "Hardware injection",
				    "Sc_NI_LoopIn",
				    gtime,
				    (float) simEvent->timeBefore,
				    (float) simEvent->timeAfter,
				    simEvent->amplitude,
				    0);
	  ris = 
	    parseFileName(copyEvent,
			  ":","_",lisEventString[countEvent],snrScale);
	  fprintf(stderr,"Added %d parameters\n",ris);
          countEvent++;
        } else {
          fprintf(stderr,"Warning: more events than available in list\n");
        }
      }
      simEvent = simEvent->next;
    }
    if(countEvent < lisEventCount) {
      fprintf(stderr,"countEvent %d < lisEventCount %d\n",
	      countEvent, lisEventCount);
    }
    FrameWrite(frameH,oFile);
    FrameFree(frameH);
    FrFileOEnd(oFile);
    // go to the next block
  }
  // the end
}
