function Pout = Calculate_fields(Pin)
% Cout = Calculate_fields(Cin) calculate the circulating, reflected and
% transmitted fields for a PRC cavity

if isempty(Pin.reso_East)
    error(['Calculate_fields(' inputname(1) '): The resonance position must be calculated first'])
end

Pout = Pin;

% Calculate the number of iteration to reach the steady state
Accuracy = 0.001;

RT_loss = Pin.I_PRM.r;
% Have to solve RT_loss^num_iter < 0.5*accuracy
num_iter = log(0.5*Accuracy)/(log(RT_loss));
num_iter = round(num_iter);
num_iter = 200;

% the laser beam is defined outside the PRC so first pass through the PRM
% substrate
Field_in =  Change_E_n(Pin.Laser_in,Pin.I_PRM.n2);
[Field_in Field_ref]= Transmit_Reflect_Interface(Field_in,Pin.I_PRM);

PRC.Power_buildup_BP = zeros(1,num_iter);
PRC.Field_Circ = Normalise_E(Field_in,0);
PRC.Field_DP = Normalise_E(Field_in,0);
PRC.Field_S = Normalise_E(Field_in,0);
PRC.Field_leak = Normalise_E(Field_in,0);

PRC.Field_transient_W = Field_in;

PRC.Field_circ_NA = Normalise_E(Field_in,0);
PRC.Field_circ_EA = Normalise_E(Field_in,0);

for q = 1:num_iter
    
    PRC.Field_Circ = PRC.Field_Circ + PRC.Field_transient_W;
    
    PRC.Power_buildup_BP(q) = Calculate_power(PRC.Field_Circ);
    
    PRC.Field_transient_N = Pin.BS_r * Propagate_E(PRC.Field_transient_W,Pin.Propagation_mat_PRM_NIM) +...
        Pin.BS_t*Propagate_E(PRC.Field_S,Pin.Propagation_mat_SRM_NIM);
    
    PRC.Field_transient_E = Pin.BS_t * Propagate_E(PRC.Field_transient_W,Pin.Propagation_mat_PRM_EIM) +...
        Pin.BS_r * Propagate_E(PRC.Field_S,Pin.Propagation_mat_SRM_EIM);
    
    % add the phase shift for the resonnace
    PRC.Field_transient_N = PRC.Field_transient_N * Pin.reso_North;
    PRC.Field_transient_E = PRC.Field_transient_E * Pin.reso_East;
    
    % Update the input field for the arm cavities
    Pin.C_North_arm.Laser_in = PRC.Field_transient_N;
    Pin.C_East_arm.Laser_in = PRC.Field_transient_E;
    
    % Calculate the steady state fields in the arm cavity
    Pin.C_North_arm = Calculate_fields(Pin.C_North_arm);
    Pin.C_East_arm = Calculate_fields(Pin.C_East_arm);   
    
    % Take the reflected fields
    PRC.Field_transient_N = Pin.C_North_arm.Field_ref;
    PRC.Field_transient_E = Pin.C_East_arm.Field_ref;
    
   % Update the circulating fields for the arms
    PRC.Field_circ_NA = PRC.Field_circ_NA + Pin.C_North_arm.Field_circ;
    PRC.Field_circ_EA = PRC.Field_circ_EA + Pin.C_East_arm.Field_circ;
    
    % To bring on the dark fringe
    PRC.Field_transient_E = (-1)*PRC.Field_transient_E;
    
    % add the phase shift for the resonnace
    PRC.Field_transient_N = PRC.Field_transient_N * Pin.reso_North;
    PRC.Field_transient_E = PRC.Field_transient_E * Pin.reso_East;
    
    % Then propagate back toward PRM and the dark port
    
    PRC.Field_transient_W = Pin.BS_r * Propagate_E(PRC.Field_transient_N,Pin.Propagation_mat_PRM_NIM) +...
        Pin.BS_t * Propagate_E(PRC.Field_transient_E,Pin.Propagation_mat_PRM_EIM);
    
    PRC.Field_S = Pin.BS_t * Propagate_E(PRC.Field_transient_N,Pin.Propagation_mat_SRM_NIM) + ...
        Pin.BS_r  * Propagate_E(PRC.Field_transient_E,Pin.Propagation_mat_SRM_EIM);
    
    PRC.Field_leak = PRC.Field_leak + PRC.Field_transient_W;
    PRC.Field_transient_W = Reflect_mirror(PRC.Field_transient_W,Pin.I_PRM);
    
    PRC.Field_DP = PRC.Field_DP + PRC.Field_S;
    PRC.Field_S = Reflect_mirror(PRC.Field_S,Pin.I_SRM);
    %PRC.Field_S = PRC.Field_S * exp(1i*0.3);
    
    if (rem(q,num_iter/100) == 0)
        fprintf('\b\b\b\b\b\b\b\b  %-3.0i %% ',round(100*q/num_iter))
    end
    
    
end

Pout.Field_circ = PRC.Field_Circ;
Pout.Field_DP = PRC.Field_DP;
Pout.Power_buildup = PRC.Power_buildup_BP;

% Calculate the reflected field, do another round trip
PRC.Field_leak = Transmit_Reflect_Interface(PRC.Field_leak,Pin.I_PRM);
Pout.Field_ref = Field_ref + PRC.Field_leak;

Pout.Field_circ_NA = PRC.Field_circ_NA;
Pout.Field_circ_EA = PRC.Field_circ_EA;

end