function Iout = Add_polynomial(varargin)
% Iout = Add_astigmatism(Iin,value,diameter)
% Add astigmatism on a surface Iin. The astigmatism'value' is defined as the
% amplitude of the Zernike polynomial 2,2 on a unity circle of diameter
% 'diameter'


switch nargin
    case {0,1,2}
        error('Add_astigmatism(): not enough arguments, at least an object E_field (or surface) and an angle must be given')
        
    case 3
        
        Iin = varargin{1};
        zer.amp =  varargin{2};
        zer.diam =  varargin{3};
        
        Iout = Iin;
        
        if  ~isa(Iin, 'Interface')
            error('Add_astigmatism(): the first argument must be an object Interface')
        end
        
        if  ~isscalar(zer.amp)
            error('Add_astigmatism(): the second argument must be a number: the height of the Zernike polynomial')
        end
        
        if  ~isscalar(zer.diam)
            error('Add_astigmatism(): the third argument must be a number: the diameter of the Zernike circle')
        end
        
        zer.radius2D = Iin.Grid.D2_r/(zer.diam/2);
        zer.ind = find(zer.radius2D <= 1);
       
        poly_zer = @(x) (6*x.^6 - 6*x.^2); % Formula for the spherical aberration
        
        zer.map2D = zeros(Iin.Grid.Num_point);
        zer.map2D(zer.ind) = poly_zer(zer.radius2D(zer.ind));
        
        imagesc(zer.map2D*zer.amp); axis square
        
        Iout.surface =  Iin.surface + zer.map2D*zer.amp;
        
        
    otherwise
        error('Add_astigmatism(): Invalid number of input arguments, no tilt has been added')
        
end

