function varargout = Calculate_Overlap_SB(varargin)
% Calculate the overlap integral between 2 E_field, it returns a complex number
% overlap = Calculate_Overlap(E1,E2), calculate the overlap for the carrier
% field E1, E2

switch nargin
    case {0,1}
        error('Calculate_Overlap(): not enough arguments, at least two objects E_field must be given')
    case 2
        if isa(varargin{1}, 'E_Field') && isa(varargin{2}, 'E_Field')
            E1 = varargin{1};
            E2 = varargin{2};
            
            if isempty(E1.Field_SBl)
                error('Calculate_Overlap_SB(): no sideands in the first input field')
            end
            
            if isempty(E2.Field_SBl)
                error('Calculate_Overlap_SB(): no sideands in the second input field')
            end
            
            
            % Normalise the power in the 2 SBs for the 2 input fields
            power_temp = sum(sum(abs(E1.Field_SBl).^2)) * (E1.Grid.Step)^2;
            E1.Field_SBl = E1.Field_SBl / sqrt(power_temp);
            
            power_temp = sum(sum(abs(E1.Field_SBu).^2)) * (E1.Grid.Step)^2;
            E1.Field_SBu = E1.Field_SBu / sqrt(power_temp);
            
            power_temp = sum(sum(abs(E2.Field_SBl).^2)) * (E1.Grid.Step)^2;
            E2.Field_SBl = E2.Field_SBl / sqrt(power_temp);
            
            power_temp = sum(sum(abs(E2.Field_SBu).^2)) * (E1.Grid.Step)^2;
            E2.Field_SBu = E2.Field_SBu / sqrt(power_temp);
            
            over_temp1 = sum(sum(E1.Field_SBl .* conj(E2.Field_SBl))) * (E1.Grid.Step)^2;
            over_temp2 = sum(sum(E1.Field_SBu .* conj(E2.Field_SBu))) * (E1.Grid.Step)^2;
            
            switch nargout
                case 0
                    fprintf('Normalised power overlap between fields lower SB %g  \n',abs(over_temp1).^2)
                    fprintf('Normalised power overlap between fields upper SB %g  \n',abs(over_temp2).^2)
                case 1
                    varargout{1} = over_temp1;
                case 2
                     varargout{1} = over_temp1;
                     varargout{2} = over_temp2;
                otherwise
                    error('Calculate_Overlap(): Too many output argument')
            end
        else
            error('Calculate_Overlap(): The two first arguments must be E_field')
        end
        
    otherwise
        error('Calculate_Overlap(): Invalid number of input arguments, no overlap calculation is made')
end


