function Pout = Calculate_fields2(Pin)
% Cout = Calculate_fields(Cin) calculate the circulating, reflected and
% transmitted fields for a PRC cavity

if isempty(Pin.reso_East)
    error(['Calculate_fields(' inputname(1) '): The resonance position must be calculated first'])
end

Pout = Pin;

% Calculate the number of iteration to reach the steady state
Accuracy = 0.1;

RT_loss = Pin.I_PRM.r;
% Have to solve RT_loss^num_iter < 0.5*accuracy
num_iter = log(0.5*Accuracy)/(log(RT_loss));
num_iter = round(num_iter);

% the laser beam is defined outside the PRC so first pass through the PRM
% substrate
Field_in =  Change_E_n(Pin.Laser_in,Pin.I_PRM.n2);
Field_in = Transmit_Reflect_Interface(Field_in,Pin.I_PRM);

PRC.Power_buildup_BP = zeros(1,num_iter);
PRC.Field_Circ = Normalise_E(Field_in,0);
PRC.Field_DP = Normalise_E(Field_in,0);
PRC.Field_S = Normalise_E(Field_in,0);

PRC.Field_transient_W = Field_in;

%for q = 1:num_iter
for q = 1:10
       figure(q);E_plot(PRC.Field_transient_W)
    
    PRC.Field_Circ = PRC.Field_Circ + PRC.Field_transient_W;
    Calculate_power(PRC.Field_Circ)
    
    PRC.Power_buildup_BP(q) = Calculate_power(PRC.Field_Circ);
    
    PRC.Field_transient_N = Pin.BS_r * Propagate_E(PRC.Field_transient_W,Pin.Propagation_mat_PRM_NIM)
    

    
    % add the phase shift for the resonnace
    PRC.Field_transient_N = PRC.Field_transient_N * Pin.reso_North;
        
    % Reflect on the arm cavity input mirrors
    [~, PRC.Field_transient_N] = Transmit_Reflect_Mirror(PRC.Field_transient_N,Pin.M_North_arm,'AR'); % -1 to be on the dark fringe
    
    % Add the phase shift since the arm are on resonance
    
    PRC.Field_transient_N = (-1)*PRC.Field_transient_N;
       
    % add the phase shift for the resonnace
    PRC.Field_transient_N = PRC.Field_transient_N * Pin.reso_North;
        
    % Then propagate back toward PRM and the dark port
   %  Calculate_power(PRC.Field_transient_N)
   %  Calculate_power(PRC.Field_transient_E)
    
    
    PRC.Field_transient_W = Pin.BS_r * Propagate_E(PRC.Field_transient_N,Pin.Propagation_mat_PRM_NIM);
    
%     Calculate_power(Pin.BS_r * Propagate_E(PRC.Field_transient_N,Pin.Propagation_mat_PRM_NIM))
%     Calculate_power(Pin.BS_t * Propagate_E(PRC.Field_transient_E,Pin.Propagation_mat_PRM_EIM))
%     Calculate_power(PRC.Field_transient_W)
    
    
   % angle(Calculate_Overlap(Propagate_E(PRC.Field_transient_N,Pin.Propagation_mat_PRM_NIM),Propagate_E(PRC.Field_transient_E,Pin.Propagation_mat_PRM_EIM)))
    

    

 %   Calculate_power(PRC.Field_S)
   % angle(Calculate_Overlap(Propagate_E(PRC.Field_transient_N,Pin.Propagation_mat_SRM_NIM),Propagate_E(PRC.Field_transient_E,Pin.Propagation_mat_SRM_EIM)))

    
    
    
    PRC.Field_DP = PRC.Field_DP + PRC.Field_S;
    PRC.Field_S = Reflect_mirror(PRC.Field_S,Pin.I_SRM);
    %PRC.Field_S = PRC.Field_S * exp(1i*0.3);
    %PRC.Field_S = PRC.Field_S * exp(1i*Detuning_vec(pp));
    
end

Calculate_power(PRC.Field_Circ)
Calculate_power(PRC.Field_DP)

%E_plot(PRC.Field_transient_W)

% figure(104)
% plot(PRC.Power_buildup_BP)

end