function What_is_possible(varargin)
%What_is_possible: Check what you can do with the given grid

switch nargin
    case 0
        disp('Not enough arguments, at least an instancet Grid must be given')
        return
    case 1
        G =  varargin{1};
        Wavelength = 1064E-9;
        Mirror_size = 30; % !! in cm !!
        fprintf('Wavelength: %g [nm] \n',Wavelength*1E9)
        fprintf('Maximum angle for the beam allowed: %g [mrad] \n', Wavelength*G.Num_point/(2*G.Length)*1E3)
        fprintf('Minimum radius of curvature for a mirror of diameter %g cm: %g [m] \n', Mirror_size,Mirror_size*1E-2*G.Step/Wavelength)    
    case 2
        G =  varargin{1};
        Wavelength = 1064E-9;
        Mirror_size = varargin{2};
        fprintf('Wavelength: %g [nm] \n',Wavelength*1E9)
        fprintf('Maximum angle for the beam allowed: %g [mrad] \n', Wavelength*G.Num_point/(2*G.Length)*1E3)
        fprintf('Minimum radius of curvature for a mirror of diameter %g cm: %g [m] \n', Mirror_size*1E2,Mirror_size*G.Step/Wavelength)    
   
    otherwise
        disp('Invalid number of input arguments')
        return
end


end
