function E_plot(varargin)
% Display the 2D amplitude of a E_Field in a new window
% E_plot(E_Field) display the amplitude of the field in a new window
% E_plot(E_Field,zoom) display the amplitude of the field in a new window
% with a factor zoom centered in the middle of the grid

switch nargin
    case 0
        disp('Not enough arguments, at least an object E_field must be given')
        return
    case 1
        zoom_plot = 1;
    case 2
        zoom_plot = varargin{2};
    otherwise
        disp('Invalid number of input arguments, no plot is made')
        return
end
imagesc(varargin{1}.Grid.Axis,varargin{1}.Grid.Axis,abs(varargin{1}.Field))
shading interp

title_str = strrep(inputname(1),'_', '\_');

title(['Amplitude profile of the electric field: ' title_str])
axis tight
axis square
axis xy
view([0 90])

limit = varargin{1}.Grid.Length/(2*zoom_plot);
axis([-limit limit -limit limit])
end