function Display_results(Pin)
% Display_results(Pin) display the results of the PRC calculations.
% The function Calculate_fields() must have been run first

if isempty(Pin.Field_circ)
    error('Display_results(): Before displaying the results, the function Calculate_fields() must be run')
end

fprintf(' Input power in the carrier %g [W] \n',Calculate_power(Pin.Laser_in))
fprintf(' PRC carrier circulating power %g [W] \n',Calculate_power(Pin.Field_circ))
fprintf(' PRC reflected field %g [W] \n',Calculate_power(Pin.Field_ref))
fprintf(' Dark port power %g [W] \n',Calculate_power(Pin.Field_DP))

fprintf('---- Relative gain: ------ \n')
fprintf(' PRC carrier recycling gain %g \n',Calculate_power(Pin.Field_circ)/Calculate_power(Pin.Laser_in))
fprintf(' PRC DP carrier %g [W] \n',Calculate_power(Pin.Field_DP)/Calculate_power(Pin.Laser_in))
fprintf(' PRC Reflect field carrier %g  \n',Calculate_power(Pin.Field_ref)/Calculate_power(Pin.Laser_in))

if ~isempty(Pin.Laser_in.Field_SBl)
    
    [l2 u2] = Calculate_power_SB(Pin.Field_circ);
    [l1 u1] = Calculate_power_SB(Pin.Laser_in);
    
    fprintf(' PRC SB gains: %g  %g    \n',l2/l1,u2/u1)
    
    figure(106)
    E_plot_SB(Pin.Field_circ)
    
end

% figure(104)
% plot(Pin.Power_buildup)

figure(105)
clf;
subplot(2,2,1)
E_plot(Pin.Laser_in)
title('Input field')
subplot(2,2,2)
E_plot(Pin.Field_circ)
title('Circulating field')
subplot(2,2,3)
E_plot(Pin.Field_ref)
title('Reflected field')
subplot(2,2,4)
E_plot(Pin.Field_DP)
title('Dark port field')

%Calculate_power(Pin.Field_circ)*0.0216 + Calculate_power(Pin.Field_ref)

end