function Pout = Cavity_resonance_phase2(Pin)
% Pout = Cavity_resonance_phase(Pin) find the resonances of a PRC cavity
% This procedure find the resonance condition in the North and East arms of
% the cavity by adjusting the phase difference after round trips of
% light
% Calculate the resonance condition FOR THE CARRIER to maximise the
% recycling gain

if  ~isa(Pin, 'CITF')
    error('Cavity_resonance_phase(): the first argument (Pin) must be an instance of the class PRC2')
end


Pout = Pin;

% first, transmit the laser beam through PRM

Field_in = Change_E_n(Pin.Laser_in,Pin.I_PRM.n2);
Field_in = Transmit_Reflect_Interface(Field_in,Pin.I_PRM);

Field_Circ = Field_in;

num_iter = Pin.Cavity_phase_param;
Field_total = Normalise_E(Field_Circ,0);
Phase_adjust =1;

% First for the North path

for q = 1:num_iter
  
    Field_total = Field_total + Field_Circ;
        
    Field_Circ = (Pin.BS_r/abs(Pin.BS_r))*Propagate_E(Field_Circ,Pin.Propagation_mat_PRM_NIM);
    
    % Go through the north TM substrate
    [~,Field_Circ] = Transmit_Reflect_Mirror(Field_Circ,Pin.I_North_mirror,'AR');
    Field_Circ = Field_Circ;   % (-1) since the carrier is resonant in the arm
    
    % Back to the beam splitter toward PRM
    Field_Circ = (Pin.BS_r/abs(Pin.BS_r))*Propagate_E(Field_Circ,Pin.Propagation_mat_PRM_NIM)*Phase_adjust;
    Field_Circ = Reflect_mirror(Field_Circ,Pin.I_PRM);
    
    Phase_adjust = Phase_adjust * exp(-1i*angle(Calculate_Overlap(Field_Circ,Field_total)));
    
    
end

% Then find the round trip to make the eigen mode on resonnance for the
% North arm

Field_before = Field_total;
Field_Circ = Field_total;

Field_Circ = (Pin.BS_r/abs(Pin.BS_r))*Propagate_E(Field_Circ,Pin.Propagation_mat_PRM_NIM);
[~,Field_Circ] = Transmit_Reflect_Mirror(Field_Circ,Pin.I_North_mirror,'AR');
Field_Circ = Field_Circ;  
Field_Circ = (Pin.BS_r/abs(Pin.BS_r))*Propagate_E(Field_Circ,Pin.Propagation_mat_PRM_NIM);
Field_Circ = Reflect_mirror(Field_Circ,Pin.I_PRM);

Pout.reso_North = exp(-1i* angle(Calculate_Overlap(Field_Circ,Field_before)));
Pout.reso_North = sqrt(Pout.reso_North);


% Then for the East side

Field_in = Change_E_n(Pin.Laser_in,Pin.I_PRM.n2);
Field_in = Transmit_Reflect_Interface(Field_in,Pin.I_PRM);

Field_Circ = Field_in;

Field_total = Normalise_E(Field_Circ,0);
Phase_adjust =1;


for q = 1:num_iter
    
    Field_total = Field_total + Field_Circ;
    
    Field_Circ = (Pin.BS_t/abs(Pin.BS_t))*Propagate_E(Field_Circ,Pin.Propagation_mat_PRM_EIM);
    [~,Field_Circ] = Transmit_Reflect_Mirror(Field_Circ,Pin.I_East_mirror,'AR');
    Field_Circ = (-1)*Field_Circ;   % (-1)  to be on the dark fringe
    
    Field_Circ = (Pin.BS_t/abs(Pin.BS_t))*Propagate_E(Field_Circ,Pin.Propagation_mat_PRM_EIM)*Phase_adjust;
    Field_Circ = Reflect_mirror(Field_Circ,Pin.I_PRM);
    
    Phase_adjust = Phase_adjust * exp(-1i*angle(Calculate_Overlap(Field_Circ,Field_total)));
    
end

% Then find the round trip to make the eigen mode on resonnance

Field_before = Field_total;
Field_Circ = Field_total;

Field_Circ = Pin.BS_t*Propagate_E(Field_Circ,Pin.Propagation_mat_PRM_EIM);
[~,Field_Circ] = Transmit_Reflect_Mirror(Field_Circ,Pin.I_East_mirror,'AR');
Field_Circ = (-1)*Field_Circ;   %  to be on the dark fringe

Field_Circ = Pin.BS_t*Propagate_E(Field_Circ,Pin.Propagation_mat_PRM_EIM);
Field_Circ = Reflect_mirror(Field_Circ,Pin.I_PRM);

Pout.reso_East = exp(-1i* angle(Calculate_Overlap(Field_Circ,Field_before)));
Pout.reso_East = sqrt(Pout.reso_East);

disp('Found the phase for the resonant phase for the PRC')

end