function Display_results(Pin)
% Display_results(Pin) display the results of the PRC calculations.
% The function Calculate_fields() must have been run first

if isempty(Pin.Field_circ)
    error('Display_results(): Before displaying the results, the function Calculate_fields() must be run     ')
end

fprintf(' Input power in the carrier %g [W] \n',Calculate_power(Pin.Laser_in))
fprintf(' PRC Circulating power %g [W] \n',Calculate_power(Pin.Field_circ))
fprintf(' PRC reflected field %g [W] \n',Calculate_power(Pin.Field_ref))
fprintf(' Dark port power %g [W] \n',Calculate_power(Pin.Field_DP))

if ~isempty(Pin.Laser_in.Field_SBl)
    
    [l2 u2] = Calculate_power_SB(Pin.Field_circ);
    [l1 u1] = Calculate_power_SB(Pin.Laser_in);
    
    fprintf(' PRC SB gains: %g  %g    \n',l2/l1,u2/u1)
    
    figure(106)
    E_plot_SB(Pin.Field_circ)
    
end

figure(104)
plot(Pin.Power_buildup)


end