function Pout = Cavity_resonance_fine_common(Pin)
% Fine tuning of the cavity by checking maximising the circulating power on
% a smaller number of iteration
% Fine tuning for the common mode

if  ~isa(Pin, 'PRC2')
    error('Cavity_resonance_phase(): the first argument (Pin) must be an instance of the class PRC2')
end

Pout = Pin;

disp('Doing the fine tuning of the cavity, common path')

if isempty(Pin.reso_East)
    error(['Calculate_fields(' inputname(1) '): The resonance position must be calculated first'])
end

Span = 0.04;

options = optimset('Display','iter', 'TolFun',1E-8,'TolX',1E-6);
%options = optimset( 'TolFun',1E-6,'TolX',1E-5);

res = fminbnd(@(x) Inv_pcirc_com(Pin,100,x),-Span,Span,options);

Pout.reso_North = Pout.reso_North * exp(1i*res);
Pout.reso_East = Pout.reso_East * exp(1i*res);

if res == abs(Span)
    disp('Cavity_resonance_fine(): the scanning span may be too small   ')
end

fprintf('Fine tuning done, added common offset [rad]: %g   \n',res)


% ---- Fonction to calculate the inverse of the circulating power
function One_over_P = Inv_pcirc_com(Pin,nb_iter,phase_offset)
% Calculate the inverse of the circulating power, use for the fine tuning
% of the resonance

Pin.reso_North = Pin.reso_North * exp(1i*phase_offset);
Pin.reso_East = Pin.reso_East * exp(1i*phase_offset);

Pin.Cavity_iteration = nb_iter;
Pin = Calculate_fields(Pin);

One_over_P = 1/Calculate_power(Pin.Field_circ);
end
%------------------------------------------------

end

