function Pout = Cavity_resonance_phase_CP(Pin,CP)
%  Pout = Cavity_resonance_phase(Pin) find the resonances of a PRC cavity
% This procedure find the resonance condition in the North and East arms of
% the cavity using adjusting the phase difference after round trips of
% light
% Calculate the resonance FOR THE CARRIER



Pout = Pin;

% first if necessary, transmit the laser beam through PRM
if ~Pin.Laser_start_on_input
    Field_in =  Change_E_n(Pin.Laser_in,Pin.I_PRM.n2);
    Field_in = Transmit_Reflect_Interface(Field_in,Pin.I_PRM);
else 
     Field_in = Pin.Laser_in;
end

Grid_num_point_h = Pin.Laser_in.Grid.Half_num_point;
num_iter = Pin.Cavity_phase_param;
Length.phase = zeros(1,num_iter,'double');


% First for the North arm of the PRC

Field_Circ = Field_in;

for q = 2:num_iter
    Length_tmp_phase = angle(Field_Circ.Field(Grid_num_point_h,Grid_num_point_h));
    Field_Circ = Propagate_E(Field_Circ,Pin.d_PRM_NIM);
    
    % Cross the CP once
    Field_Circ = Transmit_Reflect_Mirror(Field_Circ,CP,'AR');
    
    % Go through the substrate, suppose a flat IR side
    Field_Circ = Change_E_n(Field_Circ,Pin.I_North_IM.n2);
    
    Field_Circ = (-1)*(-1)*Reflect_mirror(Field_Circ,Pin.I_North_IM);      % (-1) since the carrier is resonant in the arm
    Field_Circ = Change_E_n(Field_Circ,Pin.I_North_IM.n1);
    
    % Cross the CP in the other direction
    Field_Circ = Transmit_Reflect_Mirror(Field_Circ,CP,'HR');
    
    Field_Circ = Propagate_E(Field_Circ,Pin.d_PRM_NIM);
    Field_Circ = Reflect_mirror(Field_Circ,Pin.I_PRM);
    Length.phase(q) = angle(Field_Circ.Field(Grid_num_point_h,Grid_num_point_h))-Length_tmp_phase;
end

Length.phase = unwrap(Length.phase);
Pout.reso_North = exp(-1i*mean(Length.phase));
% To have the one way phase shift
Pout.reso_North = sqrt(Pout.reso_North);

% Do the same thing for the East arm of the PRC
Length.phase = zeros(1,num_iter,'double');
Field_Circ = Pin.Laser_in;

for q = 2:num_iter
    Length_tmp_phase = angle(Field_Circ.Field(Grid_num_point_h,Grid_num_point_h));
    Field_Circ = 1i*Propagate_E(Field_Circ,Pin.d_PRM_EIM);     %  *i because of the BS transmission
    
    % Go through the substrate, suppose a flat IR side
    Field_Circ = Change_E_n(Field_Circ,Pin.I_East_IM.n2);
    
    Field_Circ = (-1)*Reflect_mirror(Field_Circ,Pin.I_East_IM);      % (-1)*(-1) since the carrier is resonant in the arm and the dark fringe condition
    Field_Circ = Change_E_n(Field_Circ,Pin.I_East_IM.n1);
    Field_Circ = 1i*Propagate_E(Field_Circ,Pin.d_PRM_EIM);
    Field_Circ = Reflect_mirror(Field_Circ,Pin.I_PRM);
    Length.phase(q) = angle(Field_Circ.Field(Grid_num_point_h,Grid_num_point_h))-Length_tmp_phase;
end

Length.phase = unwrap(Length.phase);
Pout.reso_East = exp(-1i*mean(Length.phase));

Pout.reso_East = sqrt(Pout.reso_East);















disp(['Found the phase for the PRC ' inputname(1)])


end