function varargout = Calculate_Overlap(varargin)
% Calculate the overlap integral between 2 E_field, it returns a complex number
% overlap = Calculate_Overlap(E1,E2), calculate the overlap for the carrier
% field E1, E2

switch nargin
    case {0,1}
        error('Calculate_Overlap(): not enough arguments, at least two objects E_field must be given')
    case 2
        if isa(varargin{1}, 'E_Field') && isa(varargin{2}, 'E_Field')
            E1 = Normalise_E(varargin{1});
            E2 = Normalise_E(varargin{2});
            over_temp = sum(sum(E1.Field .* conj(E2.Field))) * (E1.Grid.Step)^2;
            
            switch nargout
                case 0
                    fprintf('Power overlap between fields %g  \n ',abs(over_temp).^2)
                case 1
                    varargout{1} = over_temp;
                otherwise
                    error('Calculate_Overlap(): Too many output argument')
            end
        else
            error('Calculate_Overlap(): The two first arguments must be E_field')
        end
        
    otherwise
        error('Calculate_Overlap(): Invalid number of input arguments, no overlap calculation is made')
end


