% Advanced LIGO dual recycling CITF

clear all; close all; clear classes
addpath(genpath('Classes'));

disp('---------------------------------------------------------------------------')
disp('                  OSCAR V3.2  - The CITF      ')
disp('  ')

G1 = Grid(256,0.4);

E_input = E_Field(G1,'w',0.0449,'R',-986);
%E_input = E_Field(G1,'w',0.0491,'R',-1431);

E_input = Add_sidebands(E_input,12.778E6,0.1);   

% Create the input substrates:
W_IM_AR = Interface(G1,'RoC',-1420,'CA',0.33,'T',1);
W_IM_HR = Interface(G1,'RoC',1420,'CA',0.33,'T',0.014);

N_IM_AR = Interface(G1,'RoC',-1420,'CA',0.33,'T',1);
N_IM_HR = Interface(G1,'RoC',1420,'CA',0.33,'T',0.014);

% Use the Virgo convention for the name

W_IM = Mirror(W_IM_HR,W_IM_AR,0.2); W_IM = Add_prop_mat(W_IM,E_input);
N_IM = Mirror(N_IM_HR,N_IM_AR,0.2); N_IM = Add_prop_mat(N_IM,E_input);

% Define PRM and SRM as interfaces

PRM = Interface(G1,'RoC',1430,'CA',0.33,'T',0.05);
SRM = Interface(G1,'RoC',1430,'CA',0.33,'T',1);

% Define the length of the PRC
% !! I used the standard representation for the CITF (laser comes from the
% west, north beam reflected by BS, east beam transmitted by BS.
% so my east arm is the Adv Virgo north arm and my north arm is the Adv
% Virgo west arm.
%

d_PRM_BS = 0.06 + 0.035*1.45 + 5.814;     % Distance PRC-POP + POP thickness * 1.45 + distance POP - BS
d_BS_W_IM =  5.245 + 0.035*1.45 + 0.2;    % BS thickness + Distance BS - CP + CP thickness * 1.45 + distance CP _ IM
d_BS_N_IM = 0.065*1.45 + 5.367 + 0.035*1.45 + 0.2 + 0.014;       % Distance BS - CP + CP thickness * 1.45 + distance CP _ IM
d_BS_SRM = 0.065*1.45 + 5.943;            % BS thickness + distance BS - SRM


CITF_AV = CITF(PRM,SRM,W_IM,N_IM,d_PRM_BS,d_BS_W_IM,d_BS_N_IM,d_BS_SRM,E_input);
%Check_matching(CITF_AV,2)

CITF_AV = Cavity_resonance_phase2(CITF_AV);


CITF_AV = Calculate_fields(CITF_AV);
Display_results(CITF_AV)












