function varargout = Calculate_power(varargin)
% Calculate the power in W of a Efield
% Use Calculate_power(E_field)
switch nargin
    case 0
        error('Calculate_power(): not enough arguments, at least an object E_field must be given')
    case 1
        if isa(varargin{1}, 'E_Field')
            power_temp = sum(sum(abs(varargin{1}.Field).^2)) * (varargin{1}.Grid.Step)^2;
                        
            switch nargout
                case 0
                    str = ['Power in the field: ' inputname(1) ' [W]:   %g  \n'];
                    fprintf(str,power_temp)
                case 1
                    varargout{1} = power_temp;
                otherwise
                    error('Calculate_power(): Too many output argument')
            end     
            
        else
            error('Calculate_power(): The first argument must be an Efield')
        end
    otherwise
        error('Calculate_power(): Invalid number of input arguments, no power calculation is made')
end


