clear all; clear classes
addpath(genpath('Classes'));

disp('---------------------------------------------------------------------------')
disp('                  OSCAR V3.12                                      ')
disp('  ')


% Define the grid for the simulation: 128 X 128, 15 cm X 15 cm
G1 = Grid(512,0.5);

% Define the incoming beam on the input mirror surface (beam radius 2 cm,
% wavefront curvature 2500 m, propagating toward the waist)
E_input = E_Field(G1,'w',0.0486792,'R',-979.31);

% Define the 2 mirrors, RofC = 2500m, 10 cm in diameter, transmission 2%,
% no loss

IM = Interface(G1,'RoC',1420,'CA',0.33,'T',0.014);
EM = Interface(G1,'RoC',1683,'CA',0.33,'T',1E-6);

IM = Add_map(IM,'mapC_ITM.txt','reso',7.8125E-4);
EM = Add_map(EM,'mapC_ETM.txt','reso',7.8125E-4);

% Use the 2 previous Interfaces and the input beam to defing a cavity 1000
% meter long
C1 = Cavity1(IM,EM,3000,E_input);

% Check the cavity parameters
% Check_stability(C1)

% To use the digital integration technique for better plot (but slower calculation time)
C1.Propagation_mat.Use_DI = true;

% Calculate the resonance length
C1 = Cavity_resonance_phase(C1);

 % Display information about the cavity
 % use the accelerated convergence scheme
tic 
 Field_circ = Get_info_AC(C1);
toc
% Normalised the circulating field to 1W
Field_circ = Normalise_E(Field_circ);

% Create the optimal Gaussian field in the cavity (with perfect mirrors)
Field_perfect = E_Field(G1,'w',0.0486792,'R',-1420);

% Substract the 2 fields
Field_perfect = Field_perfect * exp(1i * angle( Calculate_Overlap(Field_circ,Field_perfect)));

E_plot(Field_circ - Field_perfect)




