function I_plot(varargin)
% I_plot(Interface) Plot the surface of an Interface object in a new window

switch nargin
    case 0
        disp('Not enough arguments, at least an object Interface must be given')
        return
    case 1
        Inter = varargin{1};
        if isa(Inter, 'Interface')
            
            
            imagesc(varargin{1}.Grid.Axis,varargin{1}.Grid.Axis,varargin{1}.surface)
            shading interp
            title(['Surface profile: ' inputname(1)])
            axis tight
            axis square
            axis xy
            view([0 90])
            colorbar
            
        else
            disp('I_plot(): the object must be a Interface')
            return
        end
    otherwise
        disp('I_plot(): invalid number of input arguments, no plot is made')
        return
end

end