function E_plot(varargin)
% Display the 2D amplitude of a E_Field in a new window
% E_plot(E_Field) display the amplitude of the field in a new window
% E_plot(E_Field,zoom) display the amplitude of the field in a new window
% with a factor zoom centered in the middle of the grid

switch nargin
    case 0
        error('Not enough arguments, at least an object E_field must be given')
    case 1
        domain = 'space';
        scale = 'linear';
        zoom_plot = 1;
    case 2
        domain = varargin{2};
        scale = 'linear';
        zoom_plot = 1;
    case 3
        domain = varargin{2};
        scale = varargin{3};
        zoom_plot = 1;
    case 4
        domain = varargin{2};
        scale = varargin{3};
        zoom_plot = varargin{4};
    otherwise
        error('Invalid number of input arguments, no plot is made')
end

% Now test the entry

if ~isa(varargin{1},'E_Field')
    error(' E_plot(): the first argument must be a E_Field')
end

if ~(strcmp(domain,'space') || strcmp(domain,'angle') || strcmp(domain,'phase') )
    error(' E_plot():  the second argument must either be the string space, angle or phase')
end

if ~(strcmp(scale,'linear') || strcmp(scale,'log'))
    error(' E_plot(): the third argument must either be the string linear or log')
end

if ~isscalar(zoom_plot)
    error(' E_plot(): the fourth argument must be a real number >= 1')
end

title_str = strrep(inputname(1),'_', '\_');

if strcmp(domain,'angle')
    if strcmp(scale,'log')
        Angle_scale_X = varargin{1}.Grid.Axis_FFT * varargin{1}.Wavelength;
        Angle_scale_Y = varargin{1}.Grid.Axis_FFT * varargin{1}.Wavelength;
        imagesc(Angle_scale_X,Angle_scale_Y, log(abs(fftshift(fft2(varargin{1}.Field)))) )
        
        title(['Angular direction of the electric field, log scale: ' title_str])
    else
        
        Angle_scale_X = varargin{1}.Grid.Axis_FFT * varargin{1}.Wavelength;
        Angle_scale_Y = varargin{1}.Grid.Axis_FFT * varargin{1}.Wavelength;
        imagesc(Angle_scale_X,Angle_scale_Y, abs(fftshift(fft2(varargin{1}.Field))) )
        
        title(['Angular direction of the electric field: ' title_str])
        
        
    end
elseif strcmp(domain,'phase')
    imagesc(varargin{1}.Grid.Axis,varargin{1}.Grid.Axis,angle(varargin{1}.Field))
    
    title(['Phase of the electric field: ' title_str])
    
    limit_X = varargin{1}.Grid.Length/(2*zoom_plot);
    limit_Y = varargin{1}.Grid.Length/(2*zoom_plot);
    axis([-limit_X limit_X -limit_Y limit_Y])
    
else
    if strcmp(scale,'log')
        imagesc(varargin{1}.Grid.Axis,varargin{1}.Grid.Axis,log(abs(varargin{1}.Field)))
        
        title(['Amplitude profile of the electric field in log scale: ' title_str])
        
    else
        imagesc(varargin{1}.Grid.Axis,varargin{1}.Grid.Axis,abs(varargin{1}.Field))
        
        title(['Amplitude profile of the electric field in linear scale: ' title_str])
    end
    
    limit_X = varargin{1}.Grid.Length/(2*zoom_plot);
    limit_Y = varargin{1}.Grid.Length/(2*zoom_plot);
    axis([-limit_X limit_X -limit_Y limit_Y])
end

shading interp

axis equal
axis tight
view([0 90])


end