function Cout = Cavity_resonance_phase(Cin)
%  Cout = Cavity_resonance_phase(Cin) find the resonance of a cavity
% This procedure can find the resonance of the cavity by finding the
% suitable round trip phase shift to bring the circulating field on resonance.

Cout = Cin;

if ~Cin.Laser_start_on_input
    if isa(Cin.I_input, 'Interface')
        Cin.Laser_in =  Change_E_n(Cin.Laser_in,Cin.I_input.n2);
    end
    Field_Circ = Transmit_Reflect_Optic(Cin.Laser_in,Cin.I_input);
else
    Field_Circ = Cin.Laser_in;
end


num_iter = Cin.Cavity_phase_param;

Field_total = Normalise_E(Field_Circ,0);
Phase_adjust =1;


% Calculate the pseudo eigen mode in the cavity
for q = 1:num_iter
    
    Field_total = Field_total + Field_Circ;
    
    % Do a round trip
    Field_Circ = Propagate_E(Field_Circ,Cin.Propagation_mat);
    Field_Circ = Reflect_mirror(Field_Circ,Cin.I_end);
    Field_Circ = Propagate_E(Field_Circ,Cin.Propagation_mat)*Phase_adjust;
    Field_Circ = Reflect_mirror(Field_Circ,Cin.I_input);
       
    Phase_adjust = Phase_adjust * exp(-1i*angle(Calculate_Overlap(Field_Circ,Field_total)));  
end

% Then find the round trip to make the eigen mode on resonnance

    Field_before = Field_total;
    Field_Circ = Field_total;
    
    Field_Circ = Propagate_E(Field_Circ,Cin.Propagation_mat);
    Field_Circ = Reflect_mirror(Field_Circ,Cin.I_end);
    Field_Circ = Propagate_E(Field_Circ,Cin.Propagation_mat);
    Field_Circ = Reflect_mirror(Field_Circ,Cin.I_input);

Cout.Resonance_phase = exp(-1i* angle(Calculate_Overlap(Field_Circ,Field_before)));

disp(['Found the phase for resonance in cavity ' inputname(1)])

end