function Cout = Calculate_RT_mat(Cin)
%Calculate_RT_mat() Calculate the kernel for one round trip in the cavity
% C1 = Calculate_RT_mat(C1), this function calculate the kernel for one
% round trip of the light in the cavity. From this kernel, one can derive
% the eigen modes and eigen vectors of the cavity.
% !! only use with small size of grid 64X64  with 4GB RAM, or 128X128 on
% more powerful machine

if ~isempty(Cin.Cavity_EM_mat)
    disp('Calculate_RT_mat(): Cavity kernel has already been calculated  ')
end

Cout = Cin;

Num_point = Cin.Laser_in.Grid.Num_point;
tmp_mat_EM =  complex(zeros(Num_point^2));

Cin.Propagation_mat.Use_DI = true;

for mx=1:Num_point
    for py=1:Num_point
        
        E_in = Cin.Laser_in;
        E_in.Field = complex(zeros(Num_point));
        E_in.Field(mx,py) = 1;
        
        Circ_field = Propagate_E(E_in,Cin.Propagation_mat);
        Circ_field = Reflect_mirror(Circ_field,Cin.I_end,'Ref',1);
        Circ_field = Propagate_E(Circ_field,Cin.Propagation_mat);
        Circ_field = Reflect_mirror(Circ_field,Cin.I_input,'Ref',1);
        
         tmp_mat_EM((mx-1)*Num_point+py,:) = Circ_field.Field(:);
                
    end
end

Cout.Cavity_EM_mat = tmp_mat_EM;



end

