clear all; close all; clear classes
addpath(genpath('Classes'));

disp('---------------------------------------------------------------------------')
disp('                  OSCAR V3.0                                      ')
disp('  ')

tic
% Define the grid for the simulation:
G1 = Grid(256,0.4);

% Define the incoming beam on the input mirror surface
E_input = E_Field(G1,'w',0.0486,'R',-979.3);

% Define the mirrors

IM = Interface(G1,'RoC',1420,'CA',0.33,'T',0.014);

EM = Interface(G1,'RoC',1683,'CA',0.33,'T',2E-6,'L',75E-6);
%EM = Interface(G1,'RoC',1640,'CA',0.33,'T',2E-6,'L',75E-6);
%EM = Add_tilt(EM,3E-7,'y');

% Create a cavity with the 2 mirrors
C1 = Cavity1(IM,EM,3000,E_input);

% Calculate the resonance length
C1 = Cavity_resonance_phase(C1);

% To use the digital integration technique
%C1.Propagation_mat.Use_DI = true;

C1 = Calculate_fields(C1);
Display_results(C1);
 

