<?php
/*
Copyright (C) 2008,  European Gravitational Observatory 

This file is part of LogBook

LogBook is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

This file was written by Gary Hemming <gary.hemming@ego-gw.it>
*/

////////////////////////
// General functions //
//////////////////////

// Output application name and logo.
function getAppInfo($field)
{
	// Get contents to be output in top links.
	$get = "SELECT $field
			FROM tblAppInfo
			WHERE appID=1";
	$getRes = mysql_query($get);
	// Init.
	return mysql_result($getRes,0,"$field");
}
// Output application name and logo.
function getAppTitle($field)
{
	// Get contents to be output in top links.
	$get = "SELECT $field
			FROM tblAppInfo
			WHERE appID=1";
	$getRes = mysql_query($get);
	// Init.
	$val = mysql_result($getRes,0,"$field");
 	// Output application name.
	echo "				<div class=\"logoTitle\">$val </div><img src=\"images/lForLogbook.gif\" class=\"logo\" /><div class=\"logoTitle\">ogbook</div>\n";
}

// Get user info.
function getUserInfo($field,$userID)
{
	// Get user-related field.
	$get = "SELECT $field
			FROM tblUsers
			WHERE userID=$userID";
	$getRes = mysql_query($get);
	// Return.
	return mysql_result($getRes,0,"$field");
}

// Build array of tasks for which the user has requested mail notification.
function getUserMN($userID)
{
	// Get mail notification tasks for this user.
	$get = "SELECT taskFK
			FROM tblMailNotification
			WHERE userFK=$userID";
	$getRes = mysql_query($get);
	// Build userMN array.
	while($loop = mysql_fetch_array($getRes))
	{
	 	$taskFK = $loop["taskFK"];
		$array[$taskFK] = $taskFK;
	}
	// Return.
	return $array;
}

// Get mail domain for use in sending Mail Notifications.
function getDomain()
{
	// Check if domain exists in database.
	$appMailDomain = getAppInfo("appMailDomain");
	// If the domain is not currently set, try to re-build it.
	if($appMailDomain == NULL)
	{
		$appMailDomainExp = explode(".",$_SERVER["SERVER_NAME"]);
		$appMailDomain = $appMailDomainExp[1].".".$appMailDomainExp[2];
	}
	// Return domain.
	return $appMailDomain;
}

// Send email.
function sendMail($callRep,$taskFK,$appURL)
{
	// Initialise initial variables.
	$appName = getAppInfo("appName");
	$username = "osl_$appName";
	$authorName = getReportInfo("authorNames",$callRep);
	$reportTitle = getReportInfo("reportTitle",$callRep);
	$sectionName = getTaskInfo("sectionName",$taskFK);
	$domain = getDomain();
	// Initialise mail variables and paramaters.
	$to = NULL;
	$bcc = getMNRecipients($taskFK);
	$from = "$username@$domain";
	$subject = "New message in $sectionName";
	$contents = "<p>A new report has been made in the $appName Logbook by <strong>$authorName</strong>, with the title:</p>\r".
				"<p><strong>$reportTitle</strong></p>\r".
				"<p><a href=\"http://$appURL"."index.php?findRep=$callRep\">Click here to view the report</a>.</p>\r";
				// Set email parameters.
				$params = "-f" . $from;
				// Set headers to send.
				$headers = "From: " . $from . "\r\n" .
				"bcc: " . $bcc . "\r\n" .
				'X-Mailer: PHP/' . phpversion() . "\r\n" .
				"MIME-Version: 1.0\r\n" .
				"Content-Type: text/html; charset=utf-8\r\n" .
				"Reply-To: $username@$domain\r\n" .
				"Return-Path: $username@$domain\r\n" .
				"Content-Transfer-Encoding: 8bit\r\n\r\n";
				// Send email to user.
				mail($to, $subject, $contents, $headers, $params);
}

// Get mail notification recipients.
function getMNRecipients($taskFK)
{
	// Get email addresses.
	$get = "SELECT email
			FROM tblMailNotification
			LEFT JOIN tblUsers ON tblMailNotification.userFK = tblUsers.userID
			WHERE taskFK=$taskFK
			GROUP BY userFK
			ORDER BY email";
	$getRes = mysql_query($get);
	// Build list of email addresses to return to send mail function.
	while($loop = mysql_fetch_array($getRes))
	{
		$email = $loop["email"];
		$toString .= $email.",";
	}
	return $toString;
}

// Output the links at the top of the page.
function outputTopLinks($content,$loginStatus,$webAdmin,$userID)
{
 	// If the user has the relevant admin permission, make them available here.
 	if($webAdmin == 1)
 	{
		$sql = "OR accessLevel<>0";
	}
	elseif($webAdmin == 0 && $loginStatus == TRUE)
	{
		$sql = "OR accessLevel=2";
	}
	// Get contents to be output in top links.
	$get = "SELECT *
			FROM tblContents
			WHERE accessLevel=0 $sql
			ORDER BY orderPos";
	$getRes = mysql_query($get);
	// Loop through and output top links.
	while($loop = mysql_fetch_array($getRes))
	{
		// Initialise variables.
		$contentID = $loop["contentID"];
		$contentName = $loop["contentName"];
		// If this content is currently selected output the selected Class.
		$class = checkContent($content,$contentID);
		// If this is Drafts check whether the user currently has any saved and output the total if they have.
		if($contentID == 6)
		{
			$totalDrafts = countDrafts($userID);
			if($totalDrafts != 0)
			{
				$contentName .= " ($totalDrafts)";
			}
		}
		// Output top links
		echo "<a href=\"index.php?content=$contentID\" class=\"options$class\" />$contentName</a>\n";
	}
}

// Output content title
function outputContentTitle($content,$field)
{
	// Get contents to be output in top links.
	$get = "SELECT $field
			FROM tblContents
			WHERE contentID=$content";
	$getRes = mysql_query($get);
	// Init.
	$val = mysql_result($getRes,0,"$field");
	// Echo.
	echo "<p class=\"title\">$val</p>\n";
}

// Check if the content is selected.
function checkContent($content,$contentID)
{
	// If the two are equal then the user is in the selected content.
	if($content == $contentID)
	{
		return "Selected";
	}
	else
	{
		return NULL;
	}
}


// Output input box.
function outputInputBox($box,$type,$length,$imgSrc,$jsCall,$defaultVal,$class)
{
 	// If an image output the src.
 	if($imgSrc != NULL)
 	{
		$src = " src=\"images/$imgSrc\" ";
	}
 	// If calling a Javascript output it here.
 	if($jsCall != NULL)
 	{
		$js = " onclick=\"$jsCall(this)\" ";
	}
	echo "<input name=\"$box\" id=\"$box\" type=\"$type\" $src value=\"$defaultVal\" size=\"$length\" $js class=\"$class\" />\n";
}

// Output report title with specific header.
function setReportHdr($colour)
{
	echo "<style>\n";
	echo "	.section$colour\n";
	echo "	{\n";
	echo "		position: relative;\n";
	echo "		width: 100%;\n";
	echo "		min-height: 18px;\n";
	echo "		text-align: left;\n";
	echo "		font-weight: bold;\n";
	echo "		padding: 2px;\n";
	echo "		background: #$colour;\n";
	echo "		border-top: solid 1px #E2E2E2;\n";
	echo "		border-left: solid 1px #E2E2E2;\n";
	echo "		border-right: solid 1px #E2E2E2;\n";
	echo "	}\n";
	echo "</style>\n";
}

// Get the array of contents to which the user has access.
function accessArray($loginStatus,$webAdmin)
{
 	// If the user has the relevant admin permission, make them available here.
 	if($webAdmin == 1)
 	{
		$sql = "OR accessLevel<>0";
	}
	elseif($webAdmin == 0 && $loginStatus == TRUE)
	{
		$sql = "OR accessLevel=2";
	}
	// Get contents to be output in top links.
	$get = "SELECT *
			FROM tblContents
			WHERE accessLevel=0 $sql
			ORDER BY orderPos";
	$getRes = mysql_query($get);
	// Loop through and output top links.
	while($loop = mysql_fetch_array($getRes))
	{
		// Initialise variables.
		$contentID = $loop["contentID"];
		// Build array.
		$array[$contentID] = $contentID;
	}
	// Return value.
	return $array;
}

// Get first section.
function getFirstSectionID()
{
	$get = "SELECT sectionID
			FROM tblSections
			ORDER BY sectionName
			LIMIT 1";
	$getRes = mysql_query($get);
	// Return value
	return mysql_result($getRes,0,"sectionID");
}

// Confirm post.
function getPostStatus($nextStep)
{
 	if($nextStep == 3)
 	{
		$postStatus = 1;
	}
	else
	{
		$postStatus = 0;
	}
	return $postStatus;
}

// Get new report ID.
function getNewReportID($userID)
{
	// Get.
	$get = "SELECT reportID
			FROM tblReports
			WHERE authorFK=$userID AND postConfirmed=0
			ORDER BY reportID DESC
			LIMIT 1";
	$getRes = mysql_query($get);
	// Return.
	return mysql_result($getRes,0,"reportID");
}

// Get task info.
function getTaskInfo($field,$taskFK)
{
	// Get.
	$get = "SELECT $field
			FROM tblTasks
			LEFT JOIN tblSections ON tblTasks.sectionFK=tblSections.sectionID
			WHERE taskID=$taskFK";
	$getRes = mysql_query($get);
	// Return.
	return mysql_result($getRes,0,"$field");
}

// Delete all tasks associated to a section.
function deleteTasks($sectionID)
{
	$del = "DELETE FROM tblTasks
			WHERE sectionFK=$sectionID";
	$delRes = mysql_query($del);
}

// Get report info.
function getReportInfo($field,$callRep)
{
	// Get.
	$get = "SELECT $field
			FROM tblReports
			WHERE reportID=$callRep";
	$getRes = mysql_query($get);
	// Return.
	return mysql_result($getRes,0,"$field");
}

// Build SQL statement for search.
function buildSQL($request,$preview,$callRep,$userID,$reportSection,$reportTask,$srcCallRep,$srcDateFrom,$srcDateTo,$srcAuthor,$srcAuthorType,$srcKeyword,$srcKeywordType)
{
	if($preview != NULL && getReportInfo("authorFK",$callRep) == $userID)
	{
		$sql = " OR reportID = $preview";
	}
	// If searching on...
	// Section
	if($reportSection != NULL)
	{
		$sql .= " AND sectionFK=$reportSection ";
		$searchCriteria = "<strong>Section:</strong> ".getTaskInfo("sectionName",$reportSection)."<br />\n";
	}
	// Task.
	if($reportTask != NULL)
	{
		$sql .= " AND taskFK=$reportTask ";
		$searchCriteria .= "<strong>Task:</strong> ".getTaskInfo("taskName",$reportTask)."<br />\n";
	}
	// Report ID.
	if($srcCallRep != NULL)
	{
		$sql .= " AND reportID=$srcCallRep ";
		$searchCriteria .= "<strong>Report ID:</strong> $srcCallRep<br />\n";
	}
	// Date from.
	if($srcDateFrom != NULL && $srcDateFrom != "dd-mm-yy")
	{
		$mysqlDateFrom = mysqlDateConversion($srcDateFrom);
		$sql .= " AND dateAdded >= '$mysqlDateFrom' ";
		$searchCriteria .= "<strong>Date (from):</strong> $srcDateFrom<br />\n";
	}
	// Date To.
	if($srcDateTo != NULL && $srcDateTo != "dd-mm-yy")
	{
		$mysqlDateTo = mysqlDateToConversion($srcDateTo);
		$sql .= " AND dateAdded < '$mysqlDateTo' ";
		$searchCriteria .= "<strong>Date (to):</strong> $srcDateTo<br />\n";
	}
	// Author.
	if($srcAuthor != NULL)
	{
	 	// Exact string.
		if($srcAuthorType == 1)
		{
			$sql .= " AND authorNames LIKE '%$srcAuthor%' ";
		}
		// Any.
		elseif($srcAuthorType == 2)
		{
			// Explode string.
			$authorArray = explode(" ",$srcAuthor);
			$sql .= " AND (";
			foreach($authorArray as $key => $val)
			{
				if($checkForOR == TRUE)
				{
					$sql .= " OR ";
				}
				$sql .= "authorNames LIKE '%$val%' ";
			 	$checkForOR = TRUE;
			}
			$sql .= ") ";
		}
		// All.
		elseif($srcAuthorType == 3)
		{
			// Explode string.
			$authorArray = explode(" ",$srcAuthor);
			$sql .= " AND (";
			foreach($authorArray as $key => $val)
			{
				if($checkForAND == TRUE)
				{
					$sql .= " AND ";
				}
				$sql .= "authorNames LIKE '%$val%' ";
			 	$checkForAND = TRUE;
			}
			$sql .= ") ";
		}
		$searchCriteria .= "<strong>Author(s):</strong> $srcAuthor (".getSearchStringType($srcAuthorType).")<br />\n";
	}
	// Keyword.
	if($srcKeyword != NULL)
	{
	 	// Exact string.
		if($srcKeywordType == 1)
		{
			$sql .= " AND (reportText LIKE '%$srcKeyword%' OR reportTitle LIKE '%$srcKeyword%' ) ";
		}
		// Any.
		elseif($srcKeywordType == 2)
		{
			// Explode string.
			$keywordArray = explode(" ",$srcKeyword);
			$sql .= " AND (";
			foreach($keywordArray as $key => $val)
			{
				if($checkForKeyOR == TRUE)
				{
					$sql .= " OR ";
				}
				$sql .= "(reportText LIKE '%$val%' OR reportTitle LIKE '%$val%') ";
			 	$checkForKeyOR = TRUE;
			}
			$sql .= ") ";
		}
		// All.
		elseif($srcKeywordType == 3)
		{
			// Explode string.
			$keywordArray = explode(" ",$srcKeyword);
			$sql .= " AND (";
			foreach($keywordArray as $key => $val)
			{
				if($checkForKeyAND == TRUE)
				{
					$sql .= " AND ";
				}
				$sql .= "(reportText LIKE '%$val%' OR reportTitle LIKE '%$val%') ";
			 	$checkForKeyAND = TRUE;
			}
			$sql .= ") ";
		}
		$srcKeywordArray = explode(" ",$srcKeyword);
		// Colour each individual keyword.
		foreach($srcKeywordArray as $key => $val)
		{
			$colour = getColour($key);
			$srcKeyword = str_replace("$val", "<font color=\"$colour\">$val</font>", $srcKeyword);
		}	
		$searchCriteria .= "<strong>Keyword(s):</strong> $srcKeyword (".getSearchStringType($srcKeywordType).")<br />\n";
	}
	if($request == "sql")
	{
		return $sql;
	}
	elseif($request == "searchCriteria")
	{
		return $searchCriteria;
	}
}

// Build keyword array.
function getColour($key)
{
 	if($key == 0)
 	{
		$colour = "red";
	}
 	elseif($key == 1)
 	{
		$colour = "green";
	}
 	elseif($key == 2)
 	{
		$colour = "blue";
	}
 	elseif($key == 3)
 	{
		$colour = "cyan";
	}
 	elseif($key == 4)
 	{
		$colour = "yellow";
	}
 	elseif($key == 5)
 	{
		$colour = "purple";
	}
 	elseif($key == 6)
 	{
		$colour = "orange";
	}
 	elseif($key == 7)
 	{
		$colour = "aqua";
	}
 	elseif($key == 8)
 	{
		$colour = "fuchsia";
	}
 	elseif($key == 9)
 	{
		$colour = "lime";
	}
 	elseif($key == 10)
 	{
		$colour = "maroon";
	}
 	elseif($key == 11)
 	{
		$colour = "navy";
	}
 	elseif($key == 12)
 	{
		$colour = "olive";
	}
 	elseif($key == 13)
 	{
		$colour = "silver";
	}
 	elseif($key > 13)
 	{
		$colour = "teal";
	}
	return $colour;
}

// Get report display information.
function reportTotalDisplay($sql,$counter,$searchCriteria,$reportSection,$reportTask,$srcCallRep,$srcDateFrom,$srcDateTo,$srcAuthor,$srcAuthorType,$srcKeyword,$srcKeywordType,$startPage)
{
	// Get reports.
	$get = "SELECT COUNT(reportID) AS 'totalReports'
			FROM tblReports
			LEFT JOIN tblTasks ON tblReports.taskFK = tblTasks.taskID
			LEFT JOIN tblSections ON tblTasks.sectionFK = tblSections.sectionID
			LEFT JOIN tblUsers ON tblReports.authorFK = tblUsers.userID
			WHERE postConfirmed=1 $sql";
	$getRes = mysql_query($get);
	// Init.
	$reportTotal = mysql_result($getRes,0,"totalReports");
	if($reportTotal != 1)
	{
		$reportTxt = "s";
	}
	// Set div as it will be different between normal display and Search.
	if($searchCriteria != NULL)
	{
	 	$div = "Src";
	}
	// Deal with pagination.
	if($counter == NULL)
	{
		// Set default start.
		$startRecord = 1;
		// If there are less than 21 reports, set the last record total to that returned by the query.
		if($reportTotal < 21)
		{
			$endRecord = $reportTotal;
		}
		// Otherwise set it to 20 as only 20 reports can be displayed at a time.
		else
		{
			$endRecord = 20;
		}
	}
	else
	{
		
	}
	echo "<div id=\"reportCounter$div\">\n";
	// Output info.
	if($reportTotal > 0)
	{
		// Calculate which records are being displayed.
		if($startPage != NULL)
		{
			$startRecord = ($startPage-1)*20+1;
			$endRecord = $startRecord+19;
		}
		else
		{
			$startRecord = 1;
			$endRecord = 20;
		}
	 	// If the report total is currently less than 21, set displayEndRecord to the actual total.
		if($reportTotal <= 20)
		{
			$displayEndRecord = $reportTotal;
		}
		else
		{
			$displayEndRecord = $endRecord;
		}
		// endRecord cannot be greater than reportTotal.
		if($endRecord > $reportTotal)
		{
			$displayEndRecord = $reportTotal;
		}
		echo "Displaying report$reportTxt <strong>$startRecord</strong>-<strong>$displayEndRecord</strong> of <strong>$reportTotal</strong>.\n";
	}
	// Output links to other records.
	if($reportTotal > 20)
	{
		echo "Go to page \n";
		// First and last link.
		$startLink = $startPage-5;
		$endLink = $startPage+5;
		// Output START link.
		if($startPage > 5)
		{
			echo "<a href=\"index.php?startPage=$b&reportSection=$reportSection&reportTask=$reportTask&srcCallRep=$srcCallRep&srcDateFrom=$srcDateFrom&srcDateTo=$srcDateTo&srcAuthor=$srcAuthor&srcAuthorType=$srcAuthorType&srcKeyword=$srcKeyword&srcKeywordType=$srcKeywordType\">Start</a> ";
		}
		// Loop through and output page links.
		for($a=20;$a<$reportTotal;$a=$a+20)
		{
			$b++;
			if(($b > $startLink && $b < $endLink) || ($endLink <= 10 && $b <= 10))
			{
			 	if($b == $startPage)
			 	{
					$outputB = "<strong>$b</strong>";
				}
				else
				{
					$outputB = $b;
				}
				echo "<a href=\"index.php?startPage=$b&reportSection=$reportSection&reportTask=$reportTask&srcCallRep=$srcCallRep&srcDateFrom=$srcDateFrom&srcDateTo=$srcDateTo&srcAuthor=$srcAuthor&srcAuthorType=$srcAuthorType&srcKeyword=$srcKeyword&srcKeywordType=$srcKeywordType\">$outputB</a> ";
			}
		}
		// Output END link.
		$b++;
		echo "<a href=\"index.php?startPage=$b&reportSection=$reportSection&reportTask=$reportTask&srcCallRep=$srcCallRep&srcDateFrom=$srcDateFrom&srcDateTo=$srcDateTo&srcAuthor=$srcAuthor&srcAuthorType=$srcAuthorType&srcKeyword=$srcKeyword&srcKeywordType=$srcKeywordType\">End</a> ";

	}
	// If the user is searching set the search again button.
	if($searchCriteria != NULL)
	{
		echo "<a href=\"index.php?content=2&reportSection=$reportSection&reportTask=$reportTask&srcCallRep=$srcCallRep&srcDateFrom=$srcDateFrom&srcDateTo=$srcDateTo&srcAuthor=$srcAuthor&srcAuthorType=$srcAuthorType&srcKeyword=$srcKeyword&srcKeywordType=$srcKeywordType\" target=\"_parent\"><img src=\"images/searchAgain.gif\" class=\"searchAgain\" /></a>\n";
	}
	echo "</div>\n";
}

// Check for comments.
function checkForComments($callRep)
{
	// Get.
	$get = "SELECT reportID
			FROM tblReports
			WHERE parentFK=$callRep AND postConfirmed=1";
	$getRes = mysql_query($get);
	// Return.
	if(mysql_fetch_array($getRes) != NULL)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

// Output comments.
function outputComments($callRep,$upload_dir,$allowed_img_type,$allowed_file_type)
{
	// Get.
	$get = "SELECT *, DATE_FORMAT(dateAdded,'%H:%i, %W %d %M %Y') AS 'dateAddedAdj'
			FROM tblReports
			WHERE parentFK=$callRep AND postConfirmed=1";
	$getRes = mysql_query($get);
	// Return.
	while($loop = mysql_fetch_array($getRes))
	{
	 	// Init.
	 	$reportID = $loop["reportID"];
 		$reportText = nl2br($loop["reportText"]);
	 	$authorNames = $loop["authorNames"];
	 	$dateAddedAdj = $loop["dateAddedAdj"];
		// Output.
		echo "<div class=\"comment\">\n";
		echo "<strong>$authorNames</strong> - $dateAddedAdj ($reportID)<br />\n";
		echo "$reportText\n";
		echo "</div>\n";
		// Check for images, files etc.
		checkForImagesAndFiles($reportID,$upload_dir,$allowed_img_type,$allowed_file_type,"Comment");
	}
}

// Upload errors.
function uploadErrorCheck($uploadError)
{
	// General error
	if($uploadError == 1)
	{
		$errorTxt = "Upload unsuccessful - An unknown error occurred during the file upload.";
	}
	// General error
	elseif($uploadError == 2)
	{
		$errorTxt = "Filename already exists.";
	}
   	// Wrong file type error.
	elseif($uploadError == 3)
	{
		$errorTxt = "This file type is not accepted for this application.";
	}
   	// File too large error.
	elseif($uploadError == 4)
	{
		$errorTxt = "This file exceeds the maximum file size for this application.";
	}
   	// Directory not writeable.
	elseif($uploadError == 5)
	{
		$errorTxt = "The directory is curretly not write-able.";
	}
   	// Directory does not exist error.
	elseif($uploadError == 6)
	{
		$errorTxt = "The directory does not exist";
	}
   	// No file uploaded.
	elseif($uploadError == 7)
	{
		$errorTxt = "No file was selected for upload.";
	}
	echo "		<p class=\"uploadError\"><img src=\"images/attention.gif\" /> Upload unsuccessful - $errorTxt</p>\n";
}

// Upload function.
function upload($content,$step,$callRep,$uploadError,$allowed_file_type,$allowed_img_type,$upload_dir,$addCommentTo)
{
	$uploadLocation = "uploads/";
	// If error occurred in upload output reason.
	if($uploadError != NULL)
	{
		echo uploadErrorCheck($uploadError);
	}
	// Provide possibility to upload files.
	// Open form.
	echo "<form name=\"uploadFile\" id=\"uploadFile\" method=\"POST\" action=\"includes/upload.php?content=$content&step=$step&callRep=$callRep&addCommentTo=$addCommentTo\" enctype=\"multipart/form-data\">\n";
	echo "<p>Browse to file to upload <input type=\"file\" accept=\"application/java\" name=\"filetoupload\"></p>\n";
	echo "<p>".outputUploadableTypes($allowed_file_type,$allowed_img_type)."</p>\n";
	echo "<p>Note that, when your report is posted to the Logbook, files attached to it will be ordered in the same way as they are below.</p>\n";
	echo "<p><a href=\"index.php?content=$content&callRep=$callRep&addCommentTo=$addCommentTo\"><img src=\"images/back.gif\" class=\"button\" /></a>&nbsp;<input type=\"image\" name=\"upload\" id=\"upload\" src=\"images/upload.gif\"class=\"loginButton\" /></p>\n";
	echo "<input type=\"hidden\" name='MAX_FILE_SIZE' value=\"\" align=\"left\">\n";
	// Close form and table. 
	echo "</form>\n";
	// Output files already attached to this part.
	displayFiles($callRep,$upload_dir,$content,$step,TRUE,$allowed_img_type,$allowed_file_type);
	displayFiles($callRep,$upload_dir,$content,$step,FALSE,$allowed_img_type,$allowed_file_type);
}

// Display files that have been uploaded to this report.
function displayFiles($callRep,$upload_dir,$content,$step,$onlyImgTypes,$allowed_img_type,$allowed_file_type)
{
	// Set array.
	$fileArray = glob("$upload_dir*.*");
	// Set title.
	$title = "<p><strong>Files uploaded to this report</p>\n";
	// Build array.
	foreach($fileArray as $file)
	{
		$a++;
		$stat=stat($file);
		$mtime=$stat[mtime];
		$fileArraySorted[$file]=$file;
	}
	if($fileArray != NULL)
	{
		sort($fileArraySorted);
		// Loop through and show files.
		foreach ($fileArraySorted as $key => $filename)
		{
			$explodePath = explode("/",$filename);
			if($content == 3)
			{
				$fullFilename = $explodePath[1];
			}
			else
			{
				$fullFilename = $explodePath[2];
			}
			$explodeFilename = explode(".",$fullFilename);
			$actualName = $explodeFilename[0];
			$fileType = strtolower($explodeFilename[1]);
			// Remove the ID number from the start of the file.
			$explodeActualName = explode("_",$actualName);
			$fileRepID = $explodeActualName[0];
			$actualName = $explodeActualName[2];
			// If the ID of the file is the same as that being called output the file.
			if($fileRepID == $callRep)
			{
				// Get date of last modification - upload time.
				$dateUploaded = "Uploaded ".date("H:i l, j F, Y",filemtime($filename));
				// If uploading output then display the files in a different way.
				if($content == 3)
				{
				 	$display = FALSE;
		 			// Images only.
					if($onlyImgTypes == TRUE)
					{
					 	// If this file is an image output a mini preview of it here.
						if(in_array($fileType,$allowed_img_type))
					 	{
							$title = "<p><strong>Images attached to this report:</strong></p>\n";
							$fileImg = "uploads/$fullFilename";
							$imgClass = "thumbnailImg";
							$display = TRUE;
						}
							// Otherwise output the default file type image.
//							else
//							{
//								$fileImg = "images/$fileType.gif";
//								$imgClass = "";
//							}
					}
					// Other file types.
					else
					{
						if(in_array($fileType,$allowed_file_type))
					 	{
							$title = "<p><strong>Other file types attached to this report:</strong></p>\n";
							$fileImg = "images/$fileType.gif";
							$imgClass = "";
							$display = TRUE;
						}
					}
					if($display == TRUE)
					{
					 	// Output title on first loop.
						if($titleDone == FALSE)
						{
						 	echo $title;
						 	$titleDone = TRUE;
						}
						echo "<div class=\"uploadedImg\">\n";
						echo "	<div class=\"uploadedFileType\"><a href=\"includes/confirmation.php?adminType=delFile&callRep=$callRep&fileForDel=$fullFilename\"><img src=\"images/delFile.gif\" onclick=\"return confirm('Are you sure you wish to delete this file?')\" /></a></div>\n";
						echo "	<div class=\"uploadedFileType\"><img src=\"$fileImg\"  class=\"$imgClass\" /></div>\n";
						echo "	<div class=\"uploadedFileName\"><a href=\"uploads/$fullFilename\" target=\"blank\">$actualName.$fileType</a> ($dateUploaded)</div>\n";
						echo "</div>\n";
					}
				}
				// Otherwise user is outputting from main page.
				else
				{
		 			// Images only.
					if($onlyImgTypes == TRUE)
					{
						if($fileRepID == $callRep && in_array($fileType,$allowed_img_type))
						{
							echo "<a href=\"../uploads/$fullFilename\" target=\"blank\"><img src=\"../uploads/$fullFilename\" class=\"outputImg\" /></a>";
						}
					}
					// Or other file types.
					else
					{
						if($fileRepID == $callRep && in_array($fileType,$allowed_file_type))
						{
							echo "<div class=\"uploadedImg\">\n";
							echo "	<div class=\"uploadedFileType\"><img src=\"../images/$fileType.gif\" /></div>\n";
							echo "	<div class=\"uploadedFileName\"><a href=\"../uploads/$fullFilename\" target=\"blank\">$actualName.$fileType</a> ($dateUploaded)</div>\n";
							echo "</div>\n";
						}
					}

				}
			}
		}
	}
}

// Delete files attached to a report.
function deleteFiles($callRep,$upload_dir,$fileForDel,$content,$appDir)
{
	// Get dir for deletion.
	$dir = $appDir;
	// Set array.
	$fileArray = glob("../$upload_dir*.*");
	// Build array.
	foreach($fileArray as $file)
	{
		$a++;
		$stat=stat($file);
		$mtime=$stat[mtime];
		$fileArraySorted[$file]=$file;
	}
	if($fileArray != NULL)
	{
		foreach ($fileArraySorted as $key => $filename)
		{
			$explodePath = explode("/",$filename);
			$fullFilename = $explodePath[2];
			$fileName = explode("_",$fullFilename);
			$fileID = $fileName[0];
			$fullFilenameStr = $dir.$upload_dir.$fullFilename;
			// If the part is being deleted remove all files.
			if($fileForDel == NULL && $callRep == $fileID)
			{
				// Remove file.
				unlink($fullFilenameStr);
			}
			// If the user is looking to remove a single file do so now.
			elseif($fileForDel == $fullFilename)
			{
				// Remove file.
				unlink($fullFilenameStr);
			}
		}
	}
}

// Check if files are attached to this report.
function checkForFiles($callRep,$upload_dir,$onlyImgTypes,$allowed_img_type,$allowed_file_type)
{
	// Set array.
	$fileArray = glob("$upload_dir*.*");
	// Set title.
	$title = "<p><strong>Files uploaded to this report</p>\n";
	// Build array.
	foreach($fileArray as $file)
	{
		$a++;
		$stat=stat($file);
		$mtime=$stat[mtime];
		$fileArraySorted[$file]=$file;
	}
	if($fileArray != NULL)
	{
		// Loop through and show files.
		foreach ($fileArraySorted as $key => $filename)
		{
			$explodePath = explode("/",$filename);
			$fullFilename = $explodePath[2];
			$explodeFilename = explode(".",$fullFilename);
			$actualName = $explodeFilename[0];
			$fileType = strtolower($explodeFilename[1]);
			// Remove the ID number from the start of the file.
			$explodeActualName = explode("_",$actualName);
			$fileRepID = $explodeActualName[0];
			$actualName = $explodeActualName[1];
			// If looking only for images.
			if($onlyImgTypes == TRUE)
			{
				if($fileRepID == $callRep && in_array($fileType,$allowed_img_type))
				{
					$filesAttached = TRUE;
				}
			}
			// Or other file types.
			else
			{
				if($fileRepID == $callRep && in_array($fileType,$allowed_file_type))
				{
					$filesAttached = TRUE;
				}
			}
		}
	}
	// Return value.
	return $filesAttached;
}

// Get latest file number.
function getLatestFileNumber($callRep,$upload_dir)
{
	// Set array.
	$fileArray = glob("$upload_dir*.*");
	// Build array.
	foreach($fileArray as $file)
	{
		$a++;
		$stat=stat($file);
		$mtime=$stat[mtime];
		$fileArraySorted[$file]=$file;
	}
	if($fileArray != NULL)
	{
		// Loop through and show files.
		foreach ($fileArraySorted as $key => $filename)
		{
			$explodePath = explode("/",$filename);
			$fullFilename = $explodePath[2];
			$explodeFilename = explode(".",$fullFilename);
			$actualName = $explodeFilename[0];
			// Get the ID number from the start of the file.
			$explodeActualName = explode("_",$actualName);
			$fileRepID = $explodeActualName[0];
			if($fileRepID == $callRep)
			{
				$latestFileNumber = $explodeActualName[1];
			}
		}
	}
	// At the end return the latest file number.
	return $latestFileNumber;
}

// Add leading zeroes.
function leadingZeroes($number,$zeroes)
{
	// Get current length of string.
	$strLen = strlen($number);
	// Subtract strLen from zeroes.
	$zeroesReq = $zeroes-$strLen;
	for($a=$strLen;$a<$zeroes;$a++)
	{
		$number = "0".$number;
	}
	return "$number";
}

// Output file types that may be uploaded.
function outputUploadableTypes($allowed_file_type,$allowed_img_type)
{
	// Set available file type output.
	foreach($allowed_file_type as $key)
	{
		$listOfFiles = $listOfFiles." .".$key;
	}
	// Set available img type output.
	foreach($allowed_img_type as $key)
	{
		$listOfFiles = $listOfFiles." .".$key;
	}
	// Return list of available file types
	return "<strong>Permitted file types:</strong>$listOfFiles\n";
}

// Output draft reports.
function getDrafts($userID)
{
	// Get reports.
	$get = "SELECT *, DATE_FORMAT(dateAdded,'%H:%i, %W %d %M %Y') AS 'dateAddedAdj'
			FROM tblReports
			WHERE postConfirmed=0 AND authorFK=$userID
			ORDER BY dateAdded DESC";
	$getRes = mysql_query($get);
	$checkRes = mysql_query($get);
	// Loop through and output reports.
	while($repLoop = mysql_fetch_array($getRes))
	{
		// Initialise.
		$reportID = $repLoop["reportID"];
		$reportTitle = $repLoop["reportTitle"];
		$dateAddedAdj = $repLoop["dateAddedAdj"];
		$parentFK = $repLoop["parentFK"];
		if($parentFK != 0)
		{
			$addCommentTo = $parentFK;
		}
		else
		{
			$addCommentTo = NULL;
		}	
		// Output.
		echo "<div class=\"uploadedImg\">\n";
		echo "	<div class=\"uploadedFileType\"><a href=\"includes/confirmation.php?adminType=deleteReport&callRep=$reportID\"><img src=\"images/delFile.gif\" onclick=\"return confirm('Are you sure you wish to delete this draft report?')\" /></a></div>\n";
		echo "	<div class=\"uploadedFileName\"><a href=\"index.php?content=3&callRep=$reportID&addCommentTo=$addCommentTo\">$reportTitle</a> (Last saved: $dateAddedAdj)</div>\n";
		echo "</div>\n";
	}
	// If there are no drafts output the message here.
	if(mysql_fetch_array($checkRes) == NULL)
	{
		echo "<p>You currently have no files saved to draft.</p>\n";
	}
}

// Count number of draft reports for header.
function countDrafts($userID)
{
	// Get reports.
	$get = "SELECT COUNT(reportID) AS 'totalDrafts'
			FROM tblReports
			WHERE postConfirmed=0 AND authorFK=$userID";
	$getRes = mysql_query($get);
	// Return total value.
	return mysql_result($getRes,0,"totalDrafts");
}

// Check for images and files.
function checkForImagesAndFiles($reportID,$upload_dir,$allowed_img_type,$allowed_file_type,$callType)
{
	// If images are attached to this report output them here.
	if(checkForFiles($reportID,$upload_dir,TRUE,$allowed_img_type,$allowed_file_type) == TRUE)
	{
		echo "<div class=\"attachedImagesHdr$callType\">\n";
		echo "	<strong>Images attached to this report:</strong>\n";
		echo "</div>\n";
		echo "<div class=\"attachedImages$callType\">\n";
		displayFiles($reportID,$upload_dir,$content,$step,TRUE,$allowed_img_type,$allowed_file_type);
		echo "</div>\n";
	}
	// If other file type are attached to this report output them here.
	if(checkForFiles($reportID,$upload_dir,FALSE,$allowed_img_type,$allowed_file_type) == TRUE)
	{
		echo "<div class=\"attachedImagesHdr$callType\">\n";
		echo "	<strong>Other files attached to this report:</strong>\n";
		echo "</div>\n";
		echo "<div class=\"attachedImages$callType\">\n";
		displayFiles($reportID,$upload_dir,$content,$step,FALSE,$allowed_img_type,$allowed_file_type);
		echo "</div>\n";
	}
}

// Set new section colour.
function setNewSectionColour()
{
	// Set array.
	$randArray = array('33', '66', '99', 'CC', 'FF');
	// Get individual bricks.
	$colA = array_rand($randArray);
	$colB = array_rand($randArray);
	$colC = array_rand($randArray);
	// Build colour from bricks.
	$colour = $randArray[$colA].$randArray[$colB].$randArray[$colC];
	// Return new colour.
	return $colour;
}

// Get new section ID
function getSectionID()
{
	// Get.
	$get = "SELECT sectionID
			FROM tblSections
			ORDER BY sectionID DESC
			LIMIT 1";
	$getRes = mysql_query($get);
	// Return value.
	return mysql_result($getRes,0,"sectionID");
}

// Get section info
function getSectionInfo($field,$sectionID)
{
	// Get.
	$get = "SELECT $field
			FROM tblSections
			WHERE sectionID = $sectionID";
	$getRes = mysql_query($get);
	// Return value.
	return mysql_result($getRes,0,"$field");
}

// Insert new task.
function insertNewTask($sectionID,$taskName)
{
	$ins = "INSERT INTO tblTasks
			(sectionFK,taskName)
			VALUES
			($sectionID,'$taskName')";
	$insRes = mysql_query($ins);
}

// Output sections as select options.
function outputOpt($table,$orderBy,$key,$val,$sql)
{
	// Get.
	$get = "SELECT *
			FROM $table
			$sql
			ORDER BY $orderBy";
	$getRes = mysql_query($get);
	// Loop.
	while($loop = mysql_fetch_array($getRes))
	{
		// Init.
		$optKey = $loop["$key"];
		$optVal = $loop["$val"];
		// Output options.
		echo "				<option value=\"$optKey\">$optVal</option>\n";
	}
}

// Convert date to mysql string-friendly.
function mysqlDateConversion($date)
{
	$formattedDate = "20".$date[6].$date[7]."-".$date[3].$date[4]."-".$date[0].$date[1];
	return $formattedDate;
}

// Return type of search string.
function getSearchStringType($type)
{
	if($type == 1)
	{
		return "Exact string";
	}
	elseif($type == 2)
	{
		return "Any";
	}
	elseif($type == 3)
	{
		return "All";
	}
}

// Increment search date (to) by one.
function mysqlDateToConversion($date)
{
 	$day = $date[0].$date[1];
 	$day++;
	$formattedDate = "20".$date[6].$date[7]."-".$date[3].$date[4]."-".$day;
	return $formattedDate;
}

// Remove temporary files.
function removeFiles($tmpPath)
{
	$dir = $tmpPath;
	$dh = opendir($dir);
	// Open a known directory, and proceed to read its contents
    while (($file = readdir($dh)) !== false)
	{
	 	$fullFilePath = $tmpPath.$file;
    	unlink($fullFilePath);
	}
	closedir($dh);
}


// Kickout
// Kick the user out.
function kickout()
{
	// Output Javascript to kick user out.
	echo "<script type=\"text/javascript\" src=\"scripts/kickout.js\"></script>";
	echo "<script type=\"text/javascript\" src=\"scripts/kickoutCall.js\"></script>";
}
