<?php
/*
Copyright (C) 2008,  European Gravitational Observatory 

This file is part of LogBook

LogBook is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

This file was written by Gary Hemming <gary.hemming@ego-gw.it>
*/

// Insertion, update and delete, etc.

// Start sessions for log-in.
session_start();
// Connect to server.
require_once("serverConnect.php");
// Select database.
require_once("dbConnect.php");
// Call functions.
require_once("generalFunctions.php");
// Initialise general variables.
require_once("initVar.php");

// Make sure that the addCommentTo variable being NULL doesn't cause problems in MySQL.
if($addCommentTo == NULL)
{
	$addCommentTo = 0;
}

// If logged in.
if($loginStatus == TRUE)
{
	// Save report.
	if($adminType == "saveReport")
	{
	 	// If the user is posting directly to Logbook then confirm.
	 	$postStatus = getPostStatus($nextStep);
	 	// If the report does not yet exist in the database insert it.
	 	if($callRep == NULL)
	 	{
			// Insert report.
			$ins = "INSERT INTO tblReports
					(reportTitle,reportText,taskFK,authorFK,authorNames,parentFK,postConfirmed)
					VALUES
					('$reportTitle','$reportText',$reportTask,$userID,'$reportAuthors','$addCommentTo',$postStatus)";
			$insRes = mysql_query($ins);
			// Get new ID.
			$callRep = getNewReportID($userID);
		}
		// Otherwise update it.
		else
		{
		 	// If this is being edited after the event by an administrator, make sure that the authorFK and dateAdded are not 	changed.
			if(getReportInfo("postConfirmed",$callRep) == TRUE)
			{
				$authorFK = getReportInfo("authorFK",$callRep);
				$dateAdded = getReportInfo("dateAdded",$callRep);
			}
			else
			{
				$authorFK = $userID;
				$dateAdded = $now;
			}
			// Update report.
			$upd = "UPDATE tblReports
					SET reportTitle='$reportTitle',reportText='$reportText',taskFK=$reportTask,authorFK=$authorFK,parentFK='$addCommentTo',postConfirmed=$postStatus,dateAdded='$dateAdded'
					WHERE reportID=$callRep";
			$updRes = mysql_query($upd);
		}
		// Re-route accordingly.
		if($nextStep == 3)
		{
			// Send mail notification and then re-route.
			sendMail($callRep,$reportTask,$appURL);
			header("location: ../index.php");
		}
		else
		{
			// Saved to Draft - Return to report.
			if($nextStep == 1)
			{
				header("location: ../index.php?content=3&callRep=$callRep&addCommentTo=$addCommentTo");
			}
			// Adding images. Send to correct page.
			elseif($nextStep == 2)
			{
				header("location: ../index.php?content=3&step=1&callRep=$callRep&addCommentTo=$addCommentTo");
			}
			// Previewing. Go to homepage and output preview.
			elseif($nextStep == 5)
			{
				header("location: ../index.php?preview=$callRep&callRep=$callRep&addCommentTo=$addCommentTo");
			}
		}
	}

	// Delete report.
	elseif($adminType == "deleteReport")
	{
	 	// Delete.
	 	$del = "DELETE FROM tblReports
		 		WHERE reportID=$callRep";
		$delRes = mysql_query($del);
		// Delete all related files.
		deleteFiles($callRep,$upload_dir,NULL,$content,$appDir);
		// Decide where to go.
		if($adminDel == TRUE)
		{
			$nextStep = 1;
		}
		else
		{
			$nextStep = 6;
		}
		// Re-route.
		header("location: ../index.php?content=$nextStep");
	}
	
	// Delete file.
	elseif($adminType == "delFile")
	{
		// Delete specific file.
		deleteFiles($callRep,$upload_dir,$fileForDel,$content,$appDir);
		// Re-route.
		header("location: ../index.php?content=3&step=1&callRep=$callRep");
	}

	////////////////////
	// ADMIN OPTIONS //
	//////////////////
	
	// Add new section.
	elseif($adminType == "addSection")
	{
		// Check if the user is adding or editing.
		if($edSectionID == NULL)
		{
			// Get new colour for this section.
			$adSectionColour = setNewSectionColour();
			// Insert.
			$ins = "INSERT INTO tblSections
					(sectionName,sectionColour)
					VALUES
					('$adSectionName','$adSectionColour')";
			$insRes = mysql_query($ins);
			// Get new sectionID.
			$newSectionID = getSectionID();
			// Insert new task.
			insertNewTask($newSectionID,"General");
		}
		else
		{
			// Update.
			$upd = "UPDATE tblSections
					SET sectionName = '$adSectionName'
					WHERE sectionID = $edSectionID";
			$updRes = mysql_query($upd);
		}
		// Re-route.
		header("location: ../index.php?content=7");
	}
	
	// Delete section.
	elseif($adminType == "delSection")
	{
		// Delete.
		$del = "DELETE FROM tblSections
				WHERE sectionID = $edSectionID";
		$delRes = mysql_query($del);
		// Delete all tasks associated to this section.
		deleteTasks($edSectionID);
		// Re-route.
		header("location: ../index.php?content=7");
	}

	// Add new task.
	elseif($adminType == "addTask")
	{
		// Check if new task or already existing.
		if($reportTask == NULL)
		{
			// Insert.
			$ins = "INSERT INTO tblTasks
					(sectionFK,taskName)
					VALUES
					('$edSectionID','$adTaskName')";
			$insRes = mysql_query($ins);
		}
		else
		{
			$upd = "UPDATE tblTasks
					SET taskName='$adTaskName'
					WHERE taskID=$reportTask";
			$upd = mysql_query($upd);
		}
		// Re-route.
		header("location: ../index.php?content=7");
	}
	
	// Delete task.
	elseif($adminType == "delTask")
	{
		// Delete.
		$del = "DELETE FROM tblTasks
				WHERE taskID = $reportTask";
		$delRes = mysql_query($del);
		// Re-route.
		header("location: ../index.php?content=7");
	}

	// Edit application name
	elseif($adminType == "editAppName")
	{
		// Insert.
		$ins = "UPDATE tblAppInfo
				SET appName = '$adAppName', appOpen = $adAppAccess, appLoginMethod = $adAppLoginMethod, appMailDomain = '$adAppMailDomain'
				WHERE appID = 1";
		$insRes = mysql_query($ins);
		// Re-route.
		header("location: ../index.php?content=7");
	}

	// Edit user email address.
	elseif($adminType == "editUserEmail")
	{
		// Insert.
		$ins = "UPDATE tblUsers
				SET email = '$adUserEmail'
				WHERE userID = $userID";
		$insRes = mysql_query($ins);
		// Re-route.
		header("location: ../index.php?content=5");
	}

	// Edit user mail notifications.
	elseif($adminType == "editMailNotification")
	{
	 	// First of all, delete all mail notifications related specifically to this user.
	 	$del = "DELETE FROM tblMailNotification
		 		WHERE userFK = $userID";
		$delRes = mysql_query($del);
		// Once deleted, get the array posted by the user.
	 	foreach($_POST as $key => $val)
	 	{
			// If the MN term exists in the key then insert the record to the database.
			if(preg_match("/MNTaskFK/", "$key"))
			{
				// Insert.
				$ins = "INSERT INTO tblMailNotification
						(taskFK,userFK)
						VALUES
						($val,$userID)";
				$insRes = mysql_query($ins);
			}
		}
		// Re-route.
		header("location: ../index.php?content=5");
	}

	// Add User.
	elseif($adminType == "AddUser")
	{
	 	// Add new user.
	 	$ins = "INSERT INTO tblUsers
		 		(username,password,forename,surname,email,userGroupFK)
				 VALUES
				('$adUsername','$adPassword','$adForename','$adSurname','$adEmail',$adGroup)";
		$insRes = mysql_query($ins);
		// Re-route.
		header("location: ../index.php?content=8");
	}
	// Edit User.
	elseif($adminType == "EditUser")
	{
	 	// Edit existing user.
	 	$upd = "UPDATE tblUsers
		 		SET username='$adUsername',password='$adPassword',forename='$adForename',surname='$adSurname',email='$adEmail',userGroupFK='$adGroup'
				WHERE userID=$callUser";
		$updRes = mysql_query($upd);
		// Re-route.
		header("location: ../index.php?content=8");
	}
	// Delete User.
	elseif($adminType == "delUser")
	{
	 	// Delete existing user.
	 	$del = "DELETE FROM tblUsers
				WHERE userID=$callUser";
		$delRes = mysql_query($del);
		// Re-route.
		header("location: ../index.php?content=8");
	}

}
// If not logged in.
else
{
	header("location: ../index.php");
}

?>