<?php
/*
Copyright (C) 2008,  European Gravitational Observatory 

This file is part of LogBook

LogBook is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

This file was written by Gary Hemming <gary.hemming@ego-gw.it>
*/
//ini_set('display_errors','1');
// Establish connection to server.
require_once('serverConnect.php');

// Select database.
require_once('dbConnect.php');

// Call functions use throughout page.
require_once('initVar.php');

// Call functions use throughout page.
require_once('generalFunctions.php');

// Set redirect URL.
$redirectURL = "../index.php?content=$content&step=$step&callRep=$callRep&addCommentTo=$addCommentTo&uploadError=";

// Check if the directory exists or not.
if (!is_dir("../$upload_dir"))
{
   	// Directory does not exist error.
	header('Location: '.$redirectURL.'6');
	die();
}
// Check if the directory is writable error.
if (!is_writeable("../$upload_dir"))
{
   	// Directory not writeable.
	header('Location: '.$redirectURL.'5');
	die();
}
// Check if a file has been uploaded.
if (is_uploaded_file($_FILES['filetoupload']['tmp_name']))
{
	// Get the Size of the File.
    $size = $_FILES['filetoupload']['size'];
	// Make sure that $size is less than maximum file size.
    if ($size > $size_bytes)
    {
    	// File too large error.
		header('Location: '.$redirectURL.'4');
		exit();
	}
	// Check file type. Explode the string to get the extension.
	$getFilename = $_FILES['filetoupload']['name'];
	$expFilename = explode(".",$getFilename);
	$getExt = strtolower($expFilename[1]);
	$getFilenameStr = strtolower($expFilename[0]);
	$getFilenameStr = str_replace("'", "", $getFilenameStr);
	$getFilenameStr = str_replace(" ", "", $getFilenameStr);
	$getFilenameStr = str_replace("_", "", $getFilenameStr);
	if (($limit_file_type == "yes") && (!in_array($getExt,$allowed_file_type) && !in_array($getExt,$allowed_img_type)))
    {
    	// Wrong file type error.
		header('Location: '.$redirectURL.'3');
        die();
    }
    // Check if other files, of either type, are attached to this report.
	if(checkForFiles($callRep,"../$upload_dir",TRUE,$allowed_img_type,$allowed_file_type) == TRUE || checkForFiles($callRep,"../$upload_dir",FALSE,$allowed_img_type,$allowed_file_type) == TRUE)
	{
		$latestFileNumber = getLatestFileNumber($callRep,"../$upload_dir");
		$latestFileNumber++;
		$latestFileNumber = leadingZeroes($latestFileNumber,3);
//		echo $latestFileNumber;
	}
	else
	{
		$latestFileNumber = "001";
	}
	// Build new filename: $callRep_$incrementalCount.$getExt.
    $filename = $callRep."_".$latestFileNumber."_".$getFilenameStr.".".$getExt;
//    $filename = $callRep."_".$getFilenameStr.".".$getExt;
	// Check if the file already exists.
    if(file_exists($upload_dir.$filename))
	{
    	// Filename already exists error.
		header('Location: '.$redirectURL.'2');
    	exit();
    }
	// Move the file to the upload directory specified previously.
    if (move_uploaded_file($_FILES['filetoupload']['tmp_name'],"../".$upload_dir.$filename))
	{
    	// Re-direct user to part upload page.
		header('Location: '.$redirectURL.'');
	}
	else
    {
    	// General error.
		header('Location: '.$redirectURL.'1');
    }
}
// If there is no file re-route the user.
else
{
	// No file.
	header('Location: '.$redirectURL.'7');
	die();
}

?>