<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>

<?php
/*
Copyright (C) 2008,  European Gravitational Observatory 

This file is part of LogBook

LogBook is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

This file was written by Gary Hemming <gary.hemming@ego-gw.it>
*/

// Start sessions for log-in.
session_start();
	// Display PHP errors.
//	ini_set('display_errors','1');
// Connect to server.
require_once("includes/serverConnect.php");
// Select database.
require_once("includes/dbConnect.php");
// Call functions.
require_once("includes/generalFunctions.php");
// Initialise general variables.
require_once("includes/initVar.php");

?>

	<!-- #Link to stylesheet. -->
	<link href="css/general.css" rel="stylesheet" type="text/css" />
	<!-- #Output meta data. -->
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
	<!-- #Output title. -->
<?php

	echo "<title>".getAppInfo("appName")." Logbook</title>";

?> 
	<!-- #Call Javascripts. -->
	<script type="text/javascript" src="scripts/ajax.js"></script>
	<script type="text/javascript" src="scripts/clearText.js"></script>
	<script type="text/javascript" src="scripts/redirect.js"></script>
	<script type="text/javascript" src="scripts/serialNoCheck.js"></script>
	<script type="text/javascript" src="scripts/updateTasks.js"></script>
	<script type="text/javascript" src="scripts/editSection.js"></script>
<?php

// Kick out user if does not have permission.
//if($loginStatus == TRUE)
//{
	// Set user permission arrays.
	$accessArray = accessArray($loginStatus,$webAdmin);
	// If the user does not have permission call kickout function.
	if(!in_array($content,$accessArray))
	{
		// Call kickout function.
		kickout();
		die;
	}
//}

?>
</head>


<body>

	<!-- #Open main div. -->
	<div id="main">

		<!-- #Open header upper div. -->
		<div id="headerUpper">

			<!-- #Open header upper left div. -->
			<div id="headerUpperLeft">

				<!-- #Output L for Logbook image. -->

<?php

	// Output application name and logo.
	getAppTitle("appName");

?>
			<!-- #Close header upper left div. -->
			</div>

			<!-- #Open header upper right div. -->
			<div id="headerUpperRight">

				<div class="headerUpperRightInner">

<?php

	// If logged-in output user details and log-out options.
	if($loginStatus == TRUE)
	{
		echo "				<a href=\"includes/logout.php\"><img src=\"images/logout.gif\" class=\"loginButton\" /></a>\n";
		echo "				<div id=\"loginTxt\">Logged in as ".$user."</div>\n";
	}
	// Otherwise, open log-in form.
	else
	{
		echo "				<form name=\"login\" id=\"login\" method=\"post\" action=\"includes/login.php\">\n";
		// Output log-in boxes and button.
		outputInputBox("user","text","10","","clearInputBox(this)","username","login");
		outputInputBox("passw","password","10","","clearInputBox(this)","password","login");
		outputInputBox("loginButton","image","","login.gif","","","loginButton");
		// Close form.
		echo "				</form>\n";
	}
?>			
				
				</div>

				<div class="headerUpperRightInner">
			
<?php

	// Quick search.
	echo "	<form name=\"searchFrm\" id=\"searchFrm\" method=\"post\" action=\"index.php\">\n";
	echo "		<input id=\"srcKeyword\" name=\"srcKeyword\" type=\"text\" size=\"20\" onclick=\"clearInputBox(this)\" value=\"Quick search\" class=\"login\" />\n";
//	outputInputBox("srcKeyword","text","20","","clearInputBox(this)","Quick search","login");
	outputInputBox("srcKeywordType","hidden","","","","2","");
	outputInputBox("search","image","","search.gif","","","loginButton");
	echo "	</form>\n";

?>

				</div>

			<!-- #Close header upper right div. -->
			</div>
		
		<!-- #Close header upper div. -->
		</div>

		<!-- #Open header lower div. -->
		<div id="headerLower"><?php

		if(getAppInfo("appOpen") == 1 || (getAppInfo("appOpen") == 0 && $loginStatus == TRUE))
		{
			// Output link options.
			echo outputTopLinks($content,$loginStatus,$webAdmin,$userID);
		}

?>		<!-- #Close header lower div. -->
		</div>

		<!-- #Open titleContainer div. -->
		<div id="titleContainer">

		<!-- #Close titleContainer div. -->
		</div>

		<!-- #Open mainContainer div. -->
		<div id="mainContainer"><?php

		// If this Logbook is a closed application, only open it if the user has logged-in.
		if(getAppInfo("appOpen") == 0 && $loginStatus == FALSE)
		{
			echo "<p class=\"title\">This is an internal application. You need to log-in before you can use it. Note that access via group/alias accounts is not possible.</p>\n";
		}
		// Otherwise, open it to everyone.
		else
		{
			// Output iframe containing reports.
			if($content == 1)
			{
				// Build SQL string.
				$sql = buildSQL("sql",$preview,$callRep,$userID,$reportSection,$reportTask,$srcCallRep,$srcDateFrom,$srcDateTo,$srcAuthor,$srcAuthorType,$srcKeyword,$srcKeywordType);
				// Set search criteria
				$searchCriteria = buildSQL("searchCriteria",$preview,$callRep,$userID,$reportSection,$reportTask,$srcCallRep,$srcDateFrom,$srcDateTo,$srcAuthor,$srcAuthorType,$srcKeyword,$srcKeywordType);
				// Output report info beforehand.
				reportTotalDisplay($sql,$counter,$searchCriteria,$reportSection,$reportTask,$srcCallRep,$srcDateFrom,$srcDateTo,$srcAuthor,$srcAuthorType,$srcKeyword,$srcKeywordType,$startPage);
				// Output iframe.
				echo "<iframe name=\"reports\" frameborder=\"0\" scrolling=\"yes\" src=\"includes/iframeSrc.php?startPage=$startPage&webAdmin=$webAdmin&preview=$preview&reportSection=$reportSection&reportTask=$reportTask&addCommentTo=$addCommentTo&srcCallRep=$srcCallRep&srcDateFrom=$srcDateFrom&srcDateTo=$srcDateTo&srcAuthor=$srcAuthor&srcAuthorType=$srcAuthorType&srcKeyword=$srcKeyword&srcKeywordType=$srcKeywordType&printCall=$printCall&loginStatusChk=$loginStatus#$findRep\" />\n";
			}

			// Manage report
			if($content == 3)
			{
				// If adding a comment.
				if($addCommentTo != NULL)
				{
				 	// Output title.
					echo "<p class=\"title\">Add comment to ";
					echo getReportInfo("reportTitle",$addCommentTo);
					echo "</p>\n";
					// Set default report title.
					$adRepTitle = "Comment to ".getReportInfo("reportTitle",$addCommentTo);
					$adRepTaskFK = getReportInfo("taskFK",$addCommentTo);
				}
				// Adding a report.
				else
				{
				 	// Output title.
					outputContentTitle($content,"contentName");
				}
				// Add report.
				if($step == NULL)
				{
					// If the user is editing set the relevent variables.
					if($callRep != NULL)
					{
						$adRepTitle = getReportInfo("reportTitle",$callRep);
						$adRepText = getReportInfo("reportText",$callRep);
						$adRepAuthorNames = getReportInfo("authorNames",$callRep);
						$adRepTaskFK = getReportInfo("taskFK",$callRep);
					}
					else
					{
						$adRepAuthorNames = $user;
					}
					// Before outputting anything, check whether this report has not already been posted. Only output it if it has not or the user is an administrator.
					if($callRep != NULL && (getReportInfo("postConfirmed",$callRep) == TRUE && $webAdmin == 0))
					{
						kickout();
						die;
					}
					else
					{
						// Open form.
						echo "<form name=\"manageReport\" id=\"manageReport\" method=\"post\">\n";
						echo "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\" width=\"98%\">\n";
						// Report title.
						echo "	<tr>\n";
						echo "		<td height=\"30\" width=\"10%\">Title</td>\n";
						echo "		<td width=\"90%\">\n";
						echo "			<input type=\"text\" name=\"reportTitle\" id=\"reportTitle\" size=\"100\" value=\"$adRepTitle\" >\n";
						echo "			<input type=\"hidden\" name=\"callRep\" id=\"callRep\" value=\"$callRep\">\n";
						echo "		</td>\n";
						echo "	</tr>\n";
						// Report Section.
						echo "	<tr>\n";
						echo "		<td height=\"30\">Section</td>\n";
						echo "		<td>\n";
						// If the user is not adding a comment allow them to amend the section.
						if($addCommentTo == NULL)
						{
							echo "			<select name=\"reportSection\" id=\"reportSection\" onchange=\"updateTasks(0)\">\n";
							// If the user is editing set current section.
							if($callRep != NULL)
							{
								// Get currently selected section ID and name.
								$adSectionID = getTaskInfo("sectionID",$adRepTaskFK);
								$adSectionName = getTaskInfo("sectionName",$adRepTaskFK);
								echo "				<option value=\"$adSectionID\" selected>$adSectionName</option>\n";
								$sectionSQL = "WHERE sectionID <> $adSectionID";
							}
							// Get sections.
							$getSections = "SELECT *
											FROM tblSections
											$sectionSQL
											ORDER BY sectionName";
							$getSectionsRes = mysql_query($getSections);
							// Loop sections.
							while($sectionLoop = mysql_fetch_array($getSectionsRes))
							{
								// Init.
								$sectionID = $sectionLoop["sectionID"];
								$sectionName = $sectionLoop["sectionName"];
								// Output options.
								echo "				<option value=\"$sectionID\">$sectionName</option>\n";
							}
							echo "			</select>\n";
						}
						else
						{
							// Get currently selected section ID and name.
							$adSectionID = getTaskInfo("sectionID",$adRepTaskFK);
							$adSectionName = getTaskInfo("sectionName",$adRepTaskFK);
							echo $adSectionName. "	<input name=\"reportSection\" id=\"reportSection\" type=\"hidden\" value=\"$adSectionID\" />";
						}
						echo "		</td>\n";
						echo "	</tr>\n";
						// Report Tasks.
						echo "	<tr>\n";
						echo "		<td height=\"30\">Task</td>\n";
						echo "		<td>\n";
						// If the user is not adding a comment, make it possible to change section and task.
						if($addCommentTo == NULL)
						{
							echo "			<select name=\"reportTask\" id=\"reportTask\">\n";
							// Get first alphabetic session.
							if($callRep != NULL)
							{
								// Get currently selected section ID and name.
								$adTaskName = getTaskInfo("taskName",$adRepTaskFK);
								echo "				<option value=\"$adRepTaskFK\" selected>$adTaskName</option>\n";
								$taskSQL = "WHERE sectionFK=$adSectionID AND taskFK <> $adRepTaskFK";
							}
							else
							{
								$firstSection = getFirstSectionID();
								$taskSQL = "WHERE sectionFK=$firstSection";
							}
							// Get tasks.
							$getTasks = "SELECT *
										 FROM tblTasks
										 $taskSQL
										 ORDER BY taskName";
							$getTasksRes = mysql_query($getTasks);
							// Loop sections.
							while($taskLoop = mysql_fetch_array($getTasksRes))
							{
								// Init.
								$taskID = $taskLoop["taskID"];
								$taskName = $taskLoop["taskName"];
								// Output options.
								echo "				<option value=\"$taskID\">$taskName</option>\n";
							}
							echo "			</select>\n";
						}
						// Otherwise, if the user is adding a comment, display the current section value.
						else
						{
							// Get currently selected section ID and name.
							$adTaskID = getTaskInfo("taskID",$adRepTaskFK);
							$adTaskName = getTaskInfo("taskName",$adRepTaskFK);
							echo $adTaskName. "	<input name=\"reportTask\" id=\"reportTask\" type=\"hidden\" value=\"$adTaskID\" />";
						}
						echo "		</td>\n";
						echo "	</tr>\n";
						// Report details.
						if($browser == "IE")
						{
							$textareaClass = "addRepIE";
						}
						else
						{
							$textareaClass = "addRep";
						}
						echo "	<tr>\n";
						echo "		<td colspan=\"2\">\n";
						echo "			<textarea name=\"reportText\" id=\"reportText\" class=\"$textareaClass\">$adRepText</textarea>\n";
						echo "		</td>\n";
						echo "	</tr>\n";
						// Report author(s).
						echo "	<tr>\n";
						echo "		<td height=\"30\" width=\"10%\">Author(s)</td>\n";
						echo "		<td width=\"90%\">\n";
						echo "			<input type=\"text\" name=\"reportAuthors\" id=\"reportAuthors\" size=\"100\" value=\"$adRepAuthorNames\" >\n";
						echo "		</td>\n";
						echo "	</tr>\n";
						// Close form.
						echo "</form>\n";
						// Output buttons.
						echo "	<tr>\n";
						echo "		<td colspan=\"2\" height=\"30\">\n";
						echo "			<input name=\"saveToDraftButton\" id=\"saveToDraftButton\" type=\"image\" src=\"images/saveToDraft.gif\" class=\"buttonVisible\" onclick=\"send(1,'$callRep','$addCommentTo')\">\n";
						echo "			<input name=\"uploadFilesButton\" id=\"uploadFilesButton\" type=\"image\" src=\"images/uploadFiles.gif\" class=\"buttonVisible\" onclick=\"send(2,'$callRep','$addCommentTo')\">\n";
						echo "			<input name=\"previewButton\" id=\"previewButton\" type=\"image\" src=\"images/preview.gif\" class=\"buttonVisible\" onclick=\"send(5,'$callRep','$addCommentTo')\">\n";
						echo "			<input name=\"postToLogbookButton\" id=\"postToLogbookButton\" type=\"image\" src=\"images/postToLogbook.gif\" class=\"buttonVisible\" onclick=\"send(3,'$callRep','$addCommentTo')\">\n";
						// If this report is already saved and is being edited by an Administrator.
						if($callRep != 0 && getReportInfo("postConfirmed",$callRep) == TRUE && $webAdmin == TRUE)
						{
							echo "			<a href=\"includes/confirmation.php?adminType=deleteReport&adminDel=TRUE&callRep=$callRep\"><img name=\"delete\" id=\"delete\" src=\"images/delete.gif\" class=\"buttonVisible\" onclick=\"return confirm('Are you sure you want to delete this report?')\"></a>\n";
						}
						echo "		</td>\n";
						echo "	</tr>\n";
						// Close table.
						echo "</table>\n";
						echo "</form>\n";
					}
				}
				// Upload files
				elseif($step == 1)
				{
					// Open content div.
					echo "<div id=\"centralContent\" name=\"centralDiv\">\n";
					// Output header.
					echo "	<p><strong>Upload files to ".getReportInfo("reportTitle",$callRep)."</strong></p>\n";
					// Output upload form.
					upload($content,$step,$callRep,$uploadError,$allowed_file_type,$allowed_img_type,$upload_dir,$addCommentTo);
					// Close content div.
					echo "</div>\n";
				}
			}

			// Output Search.
			elseif($content == 2)
			{
				// Output title.
				outputContentTitle($content,"contentName");
				// Open content div.
				echo "<div id=\"centralContent\" name=\"centralDiv\">\n";
				// Output header.
				echo "	<p>Enter required search criteria and click on the Search button below</p>\n";
				echo "	<form name=\"searchFrm\" id=\"searchFrm\" method=\"post\" action=\"index.php\">\n";
				echo "	<table cellpadding=\"0\" cellspacing=\"1\" border=\"0\" class=\"adminTable\">\n";
				// Report Section.
				echo "		<tr>\n";
				echo "			<td class=\"tdSearchHdr\">Section / Task</td>\n";
				echo "			<td class=\"tdSearchVal\">\n";
				echo "				<select name=\"reportSection\" id=\"reportSection\" onchange=\"updateTasks(1)\">\n";
				// If the user is searching again, output the selected option.
				if($reportSection != NULL)
				{
					$defSectionName = getSectionInfo("sectionName",$reportSection);
					echo "					<option value=\"$reportSection\" selected>$defSectionName</option>\n";
				}
				// Output blank.
				echo "					<option value=\"\"></option>\n";
				// Get sections.
				$getSections = "SELECT *
								FROM tblSections
								$sectionSQL
								ORDER BY sectionName";
				$getSectionsRes = mysql_query($getSections);
				// Loop sections.
				while($sectionLoop = mysql_fetch_array($getSectionsRes))
				{
					// Init.
					$sectionID = $sectionLoop["sectionID"];
					$sectionName = $sectionLoop["sectionName"];
					// Output options.
					echo "					<option value=\"$sectionID\">$sectionName</option>\n";
				}
				echo "				</select>\n";
				echo "				<select name=\"reportTask\" id=\"reportTask\">\n";
				// If the user is searching again, output the selected option.
				if($reportTask != NULL)
				{
					$defTaskName = getTaskInfo("taskName",$reportTask);
					echo "					<option value=\"$reportTask\" selected>$defTaskName</option>\n";
					echo "					<option value=\"\"></option>\n";
				}
				// If no task has been selected...
				else
				{
					echo "					<option value=\"\"></option>\n";
				 	// If a section has been selected, get all related tasks
					if($reportSection != NULL)
					{
						// Get tasks.
						$getTasks = "SELECT *
									 FROM tblTasks
									 WHERE sectionFK=$reportSection
									 ORDER BY taskName";
						$getTasksRes = mysql_query($getTasks);
						// Loop tasks.
						while($taskLoop = mysql_fetch_array($getTasksRes))
						{
							// Init.
							$taskID = $taskLoop["taskID"];
							$taskName = $taskLoop["taskName"];
							// Output options.
							echo "					<option value=\"$taskID\">$taskName</option>\n";
						}
					}
				}
				echo "				</select>\n";
				echo "			</td>\n";
				echo "		</tr>\n";
				// Report ID.
				echo "		<tr>\n";
				echo "			<td class=\"tdSearchHdr\">Report ID</td>\n";
				echo "			<td class=\"tdSearchVal\">\n";
				echo "				<input type=\"text\" name=\"srcCallRep\" id=\"srcCallRep\" value=\"$srcCallRep\" size=\"20\" />\n";
				echo "			</td>\n";
				echo "		</tr>\n";
				// Date (from).
				if($srcDateFrom != NULL && $srcDateFrom != "dd-mm-yy")
				{
					$dateFromDefault = "value=\"$srcDateFrom\"";
				}
				else
				{
					$dateFromDefault = "value=\"dd-mm-yy\" onclick=\"clearInputBox(this)\"";
				}
				echo "		<tr>\n";
				echo "			<td class=\"tdSearchHdr\">Date (From)</td>\n";
				echo "			<td class=\"tdSearchVal\">\n";
				echo "				<input type=\"text\" name=\"srcDateFrom\" id=\"srcDateFrom\" $dateFromDefault size=\"20\" />\n";
				echo "			</td>\n";
				echo "		</tr>\n";
				// Date (to).
				if($srcDateTo != NULL && $srcDateTo != "dd-mm-yy")
				{
					$dateToDefault = "value=\"$srcDateTo\"";
				}
				else
				{
					$dateToDefault = "value=\"dd-mm-yy\" onclick=\"clearInputBox(this)\"";
				}
				echo "		<tr>\n";
				echo "			<td class=\"tdSearchHdr\">Date (To)</td>\n";
				echo "			<td class=\"tdSearchVal\">\n";
				echo "				<input type=\"text\" name=\"srcDateTo\" id=\"srcDateTo\" $dateToDefault size=\"20\" />\n";
				echo "			</td>\n";
				echo "		</tr>\n";
				// Author
				if($srcAuthorType == 1 || $srcAuthorType == NULL)
				{
					$exactChk = "checked";
				}
				elseif($srcAuthorType == 2)
				{
					$anyChk = "checked";
				}
				elseif($srcAuthorType == 3)
				{
					$allChk = "checked";
				}
				echo "		<tr>\n";
				echo "			<td class=\"tdSearchHdr\">Author</td>\n";
				echo "			<td class=\"tdSearchVal\">\n";
				echo "				<input type=\"text\" name=\"srcAuthor\" id=\"srcAuthor\" value=\"$srcAuthor\" size=\"30\" />\n";
				echo "				<input type=\"radio\" name=\"srcAuthorType\" id=\"srcAuthorType\" value=\"1\" class=\"radio\" $exactChk /> Exact string\n";
				echo "				<input type=\"radio\" name=\"srcAuthorType\" id=\"srcAuthorType\" value=\"2\" class=\"radio\" $anyChk /> Any\n";
				echo "				<input type=\"radio\" name=\"srcAuthorType\" id=\"srcAuthorType\" value=\"3\" class=\"radio\" $allChk /> All\n";
				echo "			</td>\n";
				echo "		</tr>\n";
				// Keyword
				if($srcKeywordType == 1 || $srcKeywordType == NULL)
				{
					$exactKeyChk = "checked";
				}
				elseif($srcKeywordType == 2)
				{
					$anyKeyChk = "checked";
				}
				elseif($srcKeywordType == 3)
				{
					$allKeyChk = "checked";
				}
				echo "		<tr>\n";
				echo "			<td class=\"tdSearchHdr\">Keyword</td>\n";
				echo "			<td class=\"tdSearchVal\">\n";
				echo "				<input type=\"text\" name=\"srcKeyword\" id=\"srcKeyword\" value=\"$srcKeyword\" size=\"30\" />\n";
				echo "				<input type=\"radio\" name=\"srcKeywordType\" id=\"srcKeywordType\" value=\"1\" class=\"radio\" $exactKeyChk /> Exact string\n";
				echo "				<input type=\"radio\" name=\"srcKeywordType\" id=\"srcKeywordType\" value=\"2\" class=\"radio\" $anyKeyChk /> Any\n";
				echo "				<input type=\"radio\" name=\"srcKeywordType\" id=\"srcKeywordType\" value=\"3\" class=\"radio\" $allKeyChk /> All\n";
				echo "			</td>\n";
				echo "		</tr>\n";
				// Output button.
				echo "		<tr>\n";
				echo "			<td colspan=\"2\" class=\"tdHdr\">\n";
				echo "				<a href=\"index.php?content=2\"><img src=\"images/clear.gif\" name=\"clearButton\" id=\"clearButton\" onclick=\"return confirm('Are you sure you want to clear this search form?')\" /></a>\n";
				echo "				<input type=\"image\" src=\"images/search.gif\" name=\"searchButton\" id=\"searchButton\" class=\"loginButton\" />\n";
				echo "			</td>\n";
				echo "		</tr>\n";
				echo "	</table>\n";
				echo "	</form>\n";
				// Close content div.
				echo "</div>\n";
			}


			// Output Help.
			elseif($content == 4)
			{
				// Output title.
				outputContentTitle($content,"contentName");
				// Open content div.
				echo "<div id=\"centralContent\" name=\"centralDiv\">\n";
				// Output contents.
				echo "	<p>For help on any aspect of the OSLogbook please refer to the user guide, which can be downloaded below.</p>\n";
				echo "	<p><img src=\"images/pdf.gif\" /> <a href=\"docs/OSL_UserGuide.pdf\" target=\"_blank\">User guide</a></p>\n";
				// Close content div.
				echo "</div>\n";
			}

			// Output User info.
			elseif($content == 5)
			{
				// Output title.
				outputContentTitle($content,"contentName");
				$adUserEmail = getUserInfo("email",$userID);
				$userMNArray = getUserMN($userID);
				// Open content div.
				echo "<div id=\"centralContent\" name=\"centralDiv\">\n";
				// Output header.
				echo "	<p>L-Mail is the email alert system used by the Logbook application. The information provided below enables the Logbook to automatically send email alerts when reports are posted in specific tasks.</p>\n";
				echo "	<p>In order to take advantage of this option, enter your email address and select the tasks of interest.</p>\n";
				echo "	<form name=\"frmAppName\" id=\"frmAppName\" method=\"post\" action=\"includes/confirmation.php?adminType=editUserEmail\">\n";
				echo "	<table cellpadding=\"0\" cellspacing=\"1\" border=\"0\" class=\"adminTable\">\n";
				echo "		<tr>\n";
				echo "			<td class=\"tdHdr\">Email address</td>\n";
				echo "			<td class=\"tdVal\"><input type=\"text\" name=\"adUserEmail\" id=\"adUserEmail\" value=\"$adUserEmail\" size=\"40\" /></td>\n";
				echo "			<td class=\"tdVal\"><input type=\"image\" name=\"saveUserButton\" id=\"saveUserButton\" src=\"images/save.gif\" class=\"loginButton\" /></td>\n";
				echo "		</tr>\n";
				echo "	</form>\n";
				echo "	</table>\n";
				// Output sections and tasks.
				echo "	<form name=\"frmMailNotification\" id=\"frmMailNotification\" method=\"post\" action=\"includes/confirmation.php?adminType=editMailNotification\">\n";
				echo "	<table cellpadding=\"0\" cellspacing=\"1\" border=\"0\" class=\"adminTable\">\n";
				echo "		<tr>\n";
				echo "			<td class=\"tdVal\"><strong>Choose tasks from the list below:</strong></td>\n";
				echo "		</tr>";
				// Get all sections.
				$getSections = "SELECT *
								FROM tblSections
								ORDER BY sectionName";
				$getSectionsRes = mysql_query($getSections);
				// Loop.
				while($sectionLoop = mysql_fetch_array($getSectionsRes))
				{
				 	// Init.
				 	$sectionID = $sectionLoop["sectionID"];
				 	$sectionName = $sectionLoop["sectionName"];
				 	$sectionColour = $sectionLoop["sectionColour"];
					echo "		<tr>\n";
					echo "			<td class=\"tdCheckbox\" bgcolor=\"#$sectionColour\">\n";
					echo "				$sectionName\n";
					echo "			</td>\n";
					echo "		</tr>";
					// If this section has tasks output them here.
					$getTasks = "SELECT *
								 FROM tblTasks
								 WHERE sectionFK = $sectionID
								 ORDER BY taskName";
					$getTasksRes = mysql_query($getTasks);
					// Loop.
					while($taskLoop = mysql_fetch_array($getTasksRes))
					{
					 	// Init.
					 	$taskID = $taskLoop["taskID"];
					 	$taskName = $taskLoop["taskName"];
					 	// Check if this should be checked.
					 	if(in_array($taskID,$userMNArray))
					 	{
							$checkDef = "checked";
						}
						else
						{
							$checkDef = NULL;
						}
						echo "		<tr>\n";
						echo "			<td class=\"tdCheckbox\">\n";
						echo "				<input type=\"checkbox\" id=\"MNTaskFK$taskID\" name=\"MNTaskFK$taskID\" class=\"loginButton\" value=\"$taskID\" $checkDef />\n";
						echo "				$taskName\n";
						echo "			</td>\n";
						echo "		</tr>";
					}
				}
				echo "		<tr>\n";
				echo "			<td class=\"tdCheckbox\">\n";
				echo "				<input id=\"saveMN\" name=\"saveMN\" type=\"image\" src=\"images/save.gif\" class=\"loginButton\" />\n";
				echo "			</td>\n";
				echo "		</tr>";
				echo "	</form>\n";
				echo "	</table>\n";
				// Close content div.
				echo "</div>\n";
			}

			// Output Drafts.
			elseif($content == 6)
			{
				// Output title.
				outputContentTitle($content,"contentName");
					// Open content div.
					echo "<div id=\"centralContent\" name=\"centralDiv\">\n";
					// Output header.
					echo "	<p><strong>Reports listed in this section have been saved in draft format</strong></p>\n";
					// Output Introduction.
					echo "	<p>- To edit a report click on the name below.<br />\n";
					echo "- Click on the <img src=\"images/delFile.gif\" /> button next to the filename to delete the report completely.</p>\n";
					// Output draft reports.
					getDrafts($userID);
					// Close content div.
					echo "</div>\n";
			}

			// Output Admin section.
			elseif($content == 7)
			{
				// Output title.
				outputContentTitle($content,"contentName");
				// Open content div.
				echo "<div id=\"centralContent\" name=\"centralDiv\">\n";
				// Output header.
				echo "	<p><strong>This section provides site administrators with the possibility to manage users, sections and tasks.</strong></p>\n";
				echo "<table cellpadding=\"0\" cellspacing=\"1\" border=\"0\" class=\"adminTable\">\n";
				// Tasks.
				echo "<tr>\n";
				echo "	<td colspan=\"3\" class=\"tdHdr\"><strong>Application info</strong></td>\n";
				echo "</tr>\n";
				echo "	<form name=\"frmAppName\" id=\"frmAppName\" method=\"post\" action=\"includes/confirmation.php?adminType=editAppName\">\n";
				// Application data.
				$appName = getAppInfo("appName");
				$appOpen = getAppInfo("appOpen");
				$appLoginMethod = getAppInfo("appLoginMethod");
				$appMailDomain = getAppInfo("appMailDomain");
				if($appMailDomain == NULL)
				{
					$mailDomainNote = " (No domain specified - Using: ".getDomain().")";
				}
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\">Application Name</td>\n";
				echo "	<td colspan=\"2\" class=\"tdVal\"><input name=\"adAppName\" id=\"adAppName\" value=\"$appName\" size=\"30\" /></td>\n";
				echo "</tr>\n";
				// Open access or closed?
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\">Access</td>\n";
				echo "	<td colspan=\"2\" class=\"tdVal\">\n";
				// Check the default value for the select.
				if($appOpen == 0)
				{
					$defClosed = " selected";
				}
				elseif($appOpen == 1)
				{
					$defOpen = " selected";
				}	
				echo "		<select name=\"adAppAccess\" id=\"adAppAccess\">\n";
				echo "			<option value=\"0\"$defClosed>Closed</option>\n";
				echo "			<option value=\"1\"$defOpen>Open</option>\n";
				echo "		</select>\n";
				echo "	</td>\n";
				echo "</tr>\n";
				// Decide log-in type
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\">Log-in method</td>\n";
				echo "	<td colspan=\"2\" class=\"tdVal\">\n";
				// Check the default value for the select.
				if($appLoginMethod == 0)
				{
					$defDB = " selected";
				}
				elseif($appLoginMethod == 1)
				{
					$defUNIX = " selected";
				}	
				echo "		<select name=\"adAppLoginMethod\" id=\"adAppLoginMethod\">\n";
				echo "			<option value=\"0\"$defDB>Logbook DB</option>\n";
				echo "			<option value=\"1\"$defUNIX>UNIX</option>\n";
				echo "		</select>\n";
				echo "	</td>\n";
				echo "</tr>\n";
				// Mail notification domain.
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\">E-mail domain</td>\n";
				echo "	<td colspan=\"2\" class=\"tdVal\">@<input name=\"adAppMailDomain\" id=\"adAppMailDomain\" value=\"$appMailDomain\" size=\"30\" />$mailDomainNote</td>\n";
				echo "</tr>\n";
				echo "<tr>\n";
				echo "	<td><input name=\"saveAppInfoButton\" id=\"saveAppInfoButton\" type=\"image\" src=\"images/save.gif\" class=\"loginButton\" /></td>\n";
				echo "	<td colspan=\"2\" class=\"tdBtn\"></td>\n";
				echo "</tr>\n";
				// Sections.
				echo "<tr>\n";
				echo "	<td colspan=\"3\" class=\"tdHdr\"><strong>Sections</strong></td>\n";
				echo "</tr>\n";
				// Edit section.
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\">Select section to edit</td>\n";
				echo "	<td class=\"tdVal\">\n";
				// Get existing sections.
				echo "		<select name=\"edSectionID\" id=\"edSectionID\" onchange=\"editSection()\">\n";
				// Output blank.
				echo "				<option value=\"\"></option>\n";
				outputOpt("tblSections","sectionName","sectionID","sectionName","");
				echo "		</select>\n";
				echo "	</td>\n";
				echo "	<td class=\"tdBtn\"><image name=\"delSectionButton\" id=\"delSectionButton\" src=\"images/delete.gif\" class=\"buttonHidden\" onclick=\"delSection()\" /></td>\n";
				echo "</tr>\n";
				echo "</form>\n";
				// Add section.
				// Open table and form.
				echo "<form name=\"frmaddSection\" id=\"frmaddSection\" method=\"post\">\n";
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\"><div id=\"sectionTxt\" name=\"sectionTxt\">Add section name</div></td>\n";
				echo "	<td class=\"tdVal\"><input name=\"adSectionName\" id=\"adSectionName\" value=\"\" size=\"40\" /></td>\n";
				// Close form.
				echo "</form>\n";
				echo "	<td class=\"tdBtn\"><input name=\"saveButton\" id=\"saveButton\" type=\"image\" src=\"images/save.gif\" class=\"loginButton\" onclick=\"updateSectionName()\" /></td>\n";
				echo "</tr>\n";
				// Tasks.
				echo "<tr>\n";
				echo "	<td colspan=\"3\" class=\"tdHdr\"><div id=\"taskHdr\" name=\"taskHdr\"></div></td>\n";
				echo "</tr>\n";
				// Edit Task.
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\"><div name=\"taskHdrB\" id=\"taskHdrB\"></div></td>\n";
				echo "	<td class=\"tdVal\">\n";
				// Get existing tasks.
				echo "		<select name=\"reportTask\" id=\"reportTask\" onchange=\"editTask()\" class=\"hidden\">\n";
				echo "			<option value=\"\" selected></option>\n";
				echo "		</select>\n";
				echo "	</td>\n";
				echo "	<td class=\"tdBtn\"><input name=\"delTaskBtn\" id=\"delTaskBtn\" type=\"image\" src=\"images/delete.gif\" class=\"buttonHidden\" onclick=\"delTask()\" /></td>\n";
				echo "</tr>\n";
				// Add task.
				// Open form.
				echo "<form name=\"frmaddTask\" id=\"frmaddTask\" method=\"post\">\n";
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\"><div id=\"taskTxt\" name=\"taskTxt\"></div></td>\n";
				echo "	<td class=\"tdVal\"><input name=\"adTaskName\" id=\"adTaskName\" value=\"\" size=\"40\" class=\"hidden\" /></td>\n";
				// Close form.
				echo "</form>\n";
				echo "	<td class=\"tdBtn\"><input name=\"saveTaskButton\" id=\"saveTaskButton\" type=\"image\" src=\"images/save.gif\" class=\"buttonHidden\" onclick=\"updateTaskName()\" /></td>\n";
				echo "</tr>\n";
				
				// Close table and form.
				echo "</table>\n";
				// Close content div.
				echo "</div>\n";
			}

			// Output User Management.
			elseif($content == 8)
			{
				// Output title.
				outputContentTitle($content,"contentName");
				$userHdr = "Add";
				// If user details are being edited, call them here.
				if($callUser != NULL)
				{
					$edUserID = getUserInfo("userID",$callUser);
					$edUsername = getUserInfo("username",$callUser);
					$edPassword = getUserInfo("password",$callUser);
					$edForename = getUserInfo("forename",$callUser);
					$edSurname = getUserInfo("surname",$callUser);
					$edEmail = getUserInfo("email",$callUser);
					$edGroup = getUserInfo("userGroupFK",$callUser);
					$userHdr = "Edit";
				}
				// Open content div.
				echo "<div id=\"centralContent\" name=\"centralDiv\">\n";
				// Output header.
				echo "	<p><strong>This section enables administrator to add, edit and remove users and to decide upon access levels.</strong></p>\n";
				echo "<table cellpadding=\"0\" cellspacing=\"1\" border=\"0\" class=\"adminTable\">\n";
				// Tasks.
				echo "<tr>\n";
				echo "	<td colspan=\"3\" class=\"tdHdr\"><strong>$userHdr user</strong></td>\n";
				echo "</tr>\n";
				echo "	<form name=\"frmAppName\" id=\"frmAppName\" method=\"post\" action=\"includes/confirmation.php?adminType=".$userHdr."User&callUser=$edUserID\">\n";
				// Username.
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\">Username</td>\n";
				echo "	<td colspan=\"2\" class=\"tdVal\"><input name=\"adUsername\" id=\"adUsername\" value=\"$edUsername\" size=\"40\" /></td>\n";
				echo "</tr>\n";
				// Password.
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\">Password</td>\n";
				echo "	<td colspan=\"2\" class=\"tdVal\"><input name=\"adPassword\" id=\"adPassword\" value=\"$edPassword\" size=\"40\" /></td>\n";
				echo "</tr>\n";
				// Forename.
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\">Forename</td>\n";
				echo "	<td colspan=\"2\" class=\"tdVal\"><input name=\"adForename\" id=\"adForename\" value=\"$edForename\" size=\"40\" /></td>\n";
				echo "</tr>\n";
				// Surname.
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\">Surname</td>\n";
				echo "	<td colspan=\"2\" class=\"tdVal\"><input name=\"adSurname\" id=\"adSurname\" value=\"$edSurname\" size=\"40\" /></td>\n";
				echo "</tr>\n";
				// Email.
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\">Email</td>\n";
				echo "	<td colspan=\"2\" class=\"tdVal\"><input name=\"adEmail\" id=\"adEmail\" value=\"$edEmail\" size=\"40\" /></td>\n";
				echo "</tr>\n";
				// Access level?
				echo "<tr>\n";
				echo "	<td class=\"tdHdr\">Group</td>\n";
				echo "	<td colspan=\"2\" class=\"tdVal\">\n";
				echo "		<select name=\"adGroup\" id=\"adGroup\">\n";
				// Output user groups.
				$getUG = "SELECT *
						  FROM tblUserGroups
						  ORDER BY userGroupID";
				$getUGRes = mysql_query($getUG);
				// Loop UGs.
				while($UGLoop = mysql_fetch_array($getUGRes))
				{
				 	// Init.
				 	$UGID = $UGLoop["userGroupID"];
				 	$UG = $UGLoop["userGroup"];
					$defUG = NULL;
					// Set UG level
 					if($edGroup == $UGID)
					{
						$defUG = " selected";
					}
					// Ouput
					echo "			<option value=\"$UGID\"$defUG>$UG</option>\n";
				}
				echo "		</select>\n";
				echo "	</td>\n";
				echo "</tr>\n";
				echo "<tr>\n";
				echo "	<td><input name=\"saveAppInfoButton\" id=\"saveAppInfoButton\" type=\"image\" src=\"images/save.gif\" class=\"loginButton\" />\n";
				// Output delete if editing.
				if($callUser != NULL)
				{
					echo "<a href=\"includes/confirmation.php?adminType=delUser&callUser=$callUser\"><img src=\"images/delete.gif\" onclick=\"return confirm('Are you sure you want to delete the user $edUsername?')\" /></a>\n";
				}
				echo "	</td>\n";
				echo "	<td colspan=\"2\" class=\"tdBtn\"></td>\n";
				echo "</tr>\n";
				// Close table and form.
				echo "</form>\n";
				echo "</table>\n";
				// List all current users.
				$getUsers = "SELECT userID,username,userGroup
							 FROM tblUsers
							 LEFT JOIN tblUserGroups ON tblUsers.userGroupFK = tblUserGroups.userGroupID
							 ORDER BY userGroup, username";
				$getUsersRes = mysql_query($getUsers);
				// Loop through and output them.
				while($userLoop = mysql_fetch_array($getUsersRes))
				{
					// Init.
					$listUserID = $userLoop["userID"];
					$listUsername = $userLoop["username"];
					$listUserGroup = $userLoop["userGroup"];
					if($listUserGroup != $lastUserGroup)
					{
					 	echo "<p><strong>$listUserGroup"."s</strong><br />\n";
					}
					// Output.
					echo "<a href=\"index.php?content=8&callUser=$listUserID\">$listUsername</a><br />\n";
					$lastUserGroup = $listUserGroup;
				}
				// Close content div.
				echo "</div>\n";
			}

		}
		
?>		<!-- #Close mainContainer div. -->
		</div>

	<!-- #Close main div. -->
	</div>

</body>


</html>
