<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">


<head>

<?php
/*
Copyright (C) 2008,  European Gravitational Observatory 

This file is part of LogBook

LogBook is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

This file was written by Gary Hemming <gary.hemming@ego-gw.it>
*/

// Connect to server.
require_once("serverConnect.php");
// Select database.
require_once("dbConnect.php");
// Call functions.
require_once("generalFunctions.php");
// Initialise general variables.
require_once("initVar.php");

?>

	<!-- #Link to stylesheet. -->
	<link href="../css/general.css" rel="stylesheet" type="text/css" />
	<!-- #Output meta data. -->
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
	<!-- #Output title. -->
	<title>Logbook</title>
 
</head>


<?php

// If this is a print call then output the print window.
if($printCall == TRUE)
{
	$jsCall = " onLoad=\"javascript:window.print()\"\n";
}
	echo "<body class=\"white\"$jsCall>\n";

// Set SQL to be used in preview.
// Get author of previewed report to make sure that the user is looking at their own report and not someone else's.
$searchCriteria = buildSQL("searchCriteria",$preview,$callRep,$userID,$reportSection,$reportTask,$srcCallRep,$srcDateFrom,$srcDateTo,$srcAuthor,$srcAuthorType,$srcKeyword,$srcKeywordType);
$sql = buildSQL("sql",$preview,$callRep,$userID,$reportSection,$reportTask,$srcCallRep,$srcDateFrom,$srcDateTo,$srcAuthor,$srcAuthorType,$srcKeyword,$srcKeywordType);

// If searchCriteria contains information output it here.
if($searchCriteria != NULL)
{
	echo "<p class=\"searchCriteria\"><strong>Search criteria</strong><br />\n";
	echo "$searchCriteria</p>\n";
}
// If the user has selected a start page set SQL here.
if($startPage != NULL)
{
	$lowerLimit = ($startPage-1)*20;
	$upperLimit = $lowerLimit+20;
	$limit = "$lowerLimit, 20";
}
else
{
	$limit = "20";
}

// Get reports.
$getReps = "SELECT *, DATE_FORMAT(dateAdded,'%H:%i, %W %d %M %Y') AS 'dateAddedAdj'
			FROM tblReports
			LEFT JOIN tblTasks ON tblReports.taskFK = tblTasks.taskID
			LEFT JOIN tblSections ON tblTasks.sectionFK = tblSections.sectionID
			LEFT JOIN tblUsers ON tblReports.authorFK = tblUsers.userID
			WHERE postConfirmed=1 $sql
			ORDER BY dateAdded DESC, reportID DESC
			LIMIT $limit";
$getRepsRes = mysql_query($getReps);
$checkRepsRes = mysql_query($getReps);
// Output no reports found if user is searching and nothing meets the criteria.
if(mysql_fetch_array($checkRepsRes) == NULL)
{
	echo "<p class=\"searchCriteria\">No reports meet the specified criteria.</p>\n";
}
// If the user is searching on a keyword, break it up into an array so that the font color can be changed.
if($srcKeyword != NULL)
{
	// Explode keyword string.
	$srcKeywordArray = explode(" ",$srcKeyword);
}
// Loop through and output reports.
while($repLoop = mysql_fetch_array($getRepsRes))
{
	// Initialise.
	$reportID = $repLoop["reportID"];
	$adCommentID = $reportID;
	$reportTitle = $repLoop["reportTitle"];
	foreach($srcKeywordArray as $key => $val)
	{
		$colour = getColour($key);
		$reportTitle = str_replace("$val", "<font color=\"$colour\">$val</font>", $reportTitle);
	}	
	$parentFK = $repLoop["parentFK"];
	$reportTitleClass = "reportTitle";
	$mainClass = "reportDetails";
	$authorClass = "reportAuthor";
	// If this is a comment, change a few things.
	if($parentFK != 0)
	{
		$reportTitle = $reportTitle." (Click here to view original report: <a href=\"../index.php?findRep=$parentFK\" target=\"_parent\">$parentFK</a>)";
		$reportTitleClass = "commentTitle";
		$adCommentID = $parentFK;
	}
	// If this is a preview, change a few things.
	if($preview == $reportID)
	{
		$mainClass = "reportDetailsPreview";
		$reportTitleClass = "reportTitlePreview";
		$reportTitle = $reportTitle." (Preview)";
		$authorClass = "reportAuthorPreview";
	}
	$reportText = nl2br($repLoop["reportText"]);
	foreach($srcKeywordArray as $key => $val)
	{
		$colour = getColour($key);
		$reportText = str_replace("$val", "<font color=\"$colour\">$val</font>", $reportText);
	}	
	foreach($srcKeywordArray as $key => $val)
	{
		$reportText = str_replace("$srcKeyword", "$val", $reportText);
	}	
	$sectionName = $repLoop["sectionName"];
	$sectionColour = $repLoop["sectionColour"];
	setReportHdr($sectionColour);
	$taskName = $repLoop["taskName"];
	$authorNames =  $repLoop["authorNames"];
	$dateAddedAdj = $repLoop["dateAddedAdj"];
	// Output anchor.
	echo "<a name=\"$reportID\" id=\"$reportID\"></a>\n";
	// Open section DIV.
	echo "<div class=\"section$sectionColour\">\n";
	echo "		$sectionName ($taskName)\n";
	// If the user is administrator output the Edit option.
	if($webAdmin == TRUE || ($preview != NULL && getReportInfo("authorFK",$callRep) == $userID && $preview == $reportID))
	{
		echo "		<a href=\"../index.php?content=3&callRep=$reportID&addCommentTo=$addCommentTo\" target=\"_parent\"><img src=\"../images/edit.gif\" class=\"editImg\" /></a>\n";
	}
	// Output the print icon.
	if($printCall == FALSE)
	{
		echo "<a href=\"iframeSrc.php?printCall=TRUE&srcCallRep=$reportID\" target=\"_blank\"><img src=\"../images/print_icon.gif\" class=\"printer\" /></a>";
		// If the user is logged-in output the Add Comment option.
		if($loginStatusChk == TRUE)
		{
			echo "		<a href=\"../index.php?content=3&addCommentTo=$adCommentID\" target=\"_parent\"><img src=\"../images/addComment.gif\" class=\"addComment\" /></a>\n";
		}
	}
	echo "</div>\n";
	echo "<div class=\"$authorClass\">$authorNames - $dateAddedAdj ($reportID)</div>\n";
	echo "<div class=\"$reportTitleClass\">$reportTitle</div>\n";
	echo "<div class=\"$mainClass\">\n";
	echo "$reportText\n";
	echo "</div>\n";
	// Check for Images and files.
	$callType = NULL;
	if($preview == $reportID)
	{
		$callType = "Preview";
	}
	checkForImagesAndFiles($reportID,"../$upload_dir",$allowed_img_type,$allowed_file_type,$callType);
	// Look for comments.
	if(checkForComments($reportID) == TRUE)
	{
		echo "<div class=\"attachedImagesHdr\">\n";
		echo "	<strong>Comments related to this report</strong>\n";
		echo "</div>\n";
		echo "<div class=\"attachedImages\">\n";
		outputComments($reportID,"../$upload_dir",$allowed_img_type,$allowed_file_type);
		echo "</div>\n";
	}
	// Output block to next report.
	echo "<div class=\"clearBlock\"></div>\n";
}

?>

</body>


</html>